package kimiko.coreen.app.cours.fragment;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;

import kimiko.coreen.app.cours.R;
import kimiko.coreen.app.cours.tools.dialog.Receiver;
import kimiko.coreen.app.cours.tools.dialog.TaiwaServer;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Fragment;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.provider.Settings;
import android.speech.tts.TextToSpeech;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.TextView.OnEditorActionListener;

public class DialogueFragment extends Fragment implements Receiver {
	//private static final int VOICE_RECOGNITION_REQUEST_CODE = 1001;
	private static final Locale lang = Locale.KOREAN;
	private static final String langS = "ko";
	private static final String USER_NAME = "android";
	private TextToSpeech tts;
	protected TaiwaServer taiwaServer;
	protected List<String> messages = new ArrayList<String>();
	protected ArrayAdapter<String> adapter;

	private EditText inputText, frInput;
	private ListView listView;
	private String[] exemples, exemplesTrad; //exemplesRom
	private String id;

	@Override
	public View onCreateView(LayoutInflater layoutInflater, ViewGroup container, Bundle bundle)
	{
		View rootView = layoutInflater.inflate(R.layout.fragment_dialogue, container, false);
		final Activity activity = getActivity();
		
		this.inputText = (EditText) rootView.findViewById(R.id.editInput);
		this.frInput = (EditText) rootView.findViewById(R.id.frInput);
		this.listView = (ListView) rootView.findViewById(R.id.listDialog);

		this.exemples = getResources().getStringArray(R.array.exemple);
		//this.exemplesRom = getResources().getStringArray(R.array.exemple_rom);
		this.exemplesTrad = getResources().getStringArray(R.array.exemple_trad);

		this.inputText.setOnEditorActionListener(new OnEditorActionListener() {
			@Override
			public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
				if (actionId == EditorInfo.IME_ACTION_SEND) {
					String string = v.getText().toString();
					send(string);
					v.setText("");
					return true;
				}
				return false;
			}
		});

		this.frInput.setOnEditorActionListener(new OnEditorActionListener() {
			@Override
			public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
				if (actionId == EditorInfo.IME_ACTION_SEND) {
					String string = v.getText().toString();
					final List<Integer> strings = new ArrayList<Integer>();
					for(int i=0; i<exemplesTrad.length; i++)
					{
						if(exemplesTrad[i].toLowerCase().contains(string.toLowerCase()))
							strings.add(i);
					}
					CharSequence[] charSequence = new CharSequence[strings.size()];
					for(int i =0;i< strings.size();i++)
						charSequence[i] = exemplesTrad[strings.get(i)];


					if(strings.isEmpty())
					{
						Toast.makeText(activity, R.string.pas_exemple, Toast.LENGTH_SHORT).show();
					}
					else
					{
						AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
						builder.setTitle(R.string.exemple_Title)
						.setItems(charSequence, new DialogInterface.OnClickListener() {
							public void onClick(DialogInterface dialog, int which) {
								inputText.setText(exemples[strings.get(which)]);
							}
						});
						builder.create().show();
					}
					return true;
				}
				return false;
			}
		});

		this.adapter = new ArrayAdapter<String>(this.getActivity(), android.R.layout.simple_list_item_1, this.messages);
		this.listView.setAdapter(adapter);

		this.tts = new TextToSpeech(this.getActivity().getApplicationContext(), new TextToSpeech.OnInitListener() {
			@Override
			public void onInit(int status) {
				if(status != TextToSpeech.ERROR){
					int result = tts.setLanguage(lang);
					if (result == TextToSpeech.LANG_MISSING_DATA || result == TextToSpeech.LANG_NOT_SUPPORTED) {
						Log.e("TTS", "This Language is not supported");
						//Intent installIntent = new Intent();
						//installIntent.setAction(TextToSpeech.Engine.ACTION_INSTALL_TTS_DATA);
						//startActivity(installIntent);
					}
				}				
			}
		});
		return rootView;
	}
	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		SharedPreferences settings = getActivity().getPreferences(0);
		this.id = settings.getString("ID", "0");
		if(this.id.equals("0"))
		{
			this.id = new BigInteger(30, new SecureRandom()).toString(32);
			Editor editor = settings.edit();
			editor.putString("ID", this.id);
			editor.commit();
		}
		
		AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
		builder.setTitle(R.string.dialogue)
		.setMessage(R.string.dialogue_exp)
		.setPositiveButton(R.string.ok, null);
		builder.create().show();
	}
	
	@Override
	public void onStart()
	{
		super.onStart();
		this.messages.clear();
		taiwaServer = new TaiwaServer((Receiver) this);
		try {
			String[] params = {langS};
			Boolean res = taiwaServer.execute(params).get();
			if(res)
				taiwaServer.initReceiving();
			else
				Toast.makeText(getActivity(), R.string.pas_connecte, Toast.LENGTH_SHORT).show();
		} catch (InterruptedException e) {
			e.printStackTrace();
		} catch (ExecutionException e) {
			e.printStackTrace();
		}
		sendSimple(USER_NAME+"-"+this.id);
	}
	
	@Override
	public void onStop()
	{
		super.onStop();
		try {
			taiwaServer.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public void sendSimple(String message) {
		this.taiwaServer.send(message);
	}

	public void send(String message) {
		if(message.isEmpty())
			return;
		if(!this.taiwaServer.isConnected())
			Toast.makeText(getActivity(), R.string.pas_connecte, Toast.LENGTH_SHORT).show();
			
		this.taiwaServer.send(message);
		this.add(message);
	}

	@Override
	public void receive(String message) {
		if(message.length()<2)
			return;
		String subString = message.substring(0, 2);
		if(subString.equals("R:"))
			message = message.substring(2);

		tts.speak(message, TextToSpeech.QUEUE_ADD, null);
		
		String exemple = checkExemple(message);
		if(exemple!=null)
			this.add(message + " | "+ exemple);
		else
			this.add(message);
	}

	private String checkExemple(String message) {
		for(int i = 0; i<this.exemples.length; i++)
			if(this.exemples[i].equalsIgnoreCase(message))
				return this.exemplesTrad[i];
		return null;
			
		
	}
	public void add(String message) {
		this.messages.add(0, message);
		this.adapter.notifyDataSetChanged();
	}
}
