package kimiko.coreen.app.cours.fragment;

import kimiko.coreen.app.cours.R;
import kimiko.coreen.app.cours.tools.GridVocAdapter;
import android.app.Fragment;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.GridView;
import android.widget.Switch;
import android.widget.CompoundButton.OnCheckedChangeListener;

public class VocFragment extends Fragment {
	private int index;
	
	public VocFragment(int index) {
		this.index = index;
	}
	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle bundle)
	{
		View rootView = inflater.inflate(R.layout.fragment_voc, container, false);
		getActivity().getActionBar().setTitle(getResources().getStringArray(R.array.vocabulaire)[index]);
		String type = getResources().getStringArray(R.array.vocLien)[index];
		int id = getResources().getIdentifier("voc_"+type, "array", getActivity().getPackageName());
		int idTrad = getResources().getIdentifier("voc_"+type+"_trad", "array", getActivity().getPackageName());
		int idRom = getResources().getIdentifier("voc_"+type+"_rom", "array", getActivity().getPackageName());

		Switch switchView = ((Switch) rootView.findViewById(R.id.switchTradSelec));
		Switch switchView2 = ((Switch) rootView.findViewById(R.id.switchTradTout));
		GridView gridView = ((GridView) rootView.findViewById(R.id.gridViewVoc));
		final GridVocAdapter gridVocAdapter = new GridVocAdapter(getActivity(), getResources().getStringArray(id),
				getResources().getStringArray(idRom),
				getResources().getStringArray(idTrad));

		switchView.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				gridVocAdapter.cacher(isChecked);
				gridVocAdapter.notifyDataSetChanged();
			}
		});
		switchView2.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				gridVocAdapter.cacherTout(isChecked);
				gridVocAdapter.notifyDataSetChanged();
			}
		});
		gridView.setAdapter(gridVocAdapter);
		return rootView;
	}
}
