package kimiko.coreen.app.cours.tools;

import kimiko.coreen.app.cours.R;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.Switch;
import android.widget.TextView;

public class GridVocAdapter extends BaseAdapter {
	private Context context;
	private String[] trad, voc, rom;
	private boolean[] checked;
	private boolean cacher = false;
	private boolean cacherTout = false;

	public GridVocAdapter(Context context, String[] voc, String[] rom, String[] trad) {
		this.context = context;
		this.trad = trad;
		this.rom = rom;
		this.voc = voc;
		this.checked = new boolean[this.voc.length];
	}

	@Override
	public int getCount() {
		return this.voc.length;
	}

	@Override
	public Object getItem(int position) {
		return this.voc[position];
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(final int position, View convertView, ViewGroup parent) {
		if (convertView == null) {
            LayoutInflater infalInflater = (LayoutInflater) this.context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            convertView = infalInflater.inflate(R.layout.voc_item, parent, false);
        }

		Switch switchView = (Switch) convertView.findViewById(R.id.vocConnu);
		switchView.setOnCheckedChangeListener(null);
		switchView.setChecked(checked[position]);
		switchView.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				checked[position] = isChecked;
			}
		});
		
        TextView voc = (TextView) convertView.findViewById(R.id.vocHangeul);
        TextView trad = (TextView) convertView.findViewById(R.id.vocTrad);
        TextView rom = (TextView) convertView.findViewById(R.id.vocRom);
        
        if(this.cacherTout||(checked[position]&&this.cacher))
        	trad.setVisibility(View.INVISIBLE);
        else
        	trad.setVisibility(View.VISIBLE);
        
        voc.setText(this.voc[position]);
        trad.setText(this.trad[position]);
        rom.setText(this.rom[position]);
        return convertView;
	}

	public void cacher(boolean bool) {
		this.cacher = bool;
	}
	public void cacherTout(boolean bool) {
		this.cacherTout = bool;
	}
}
