package kimiko.coreen.app.cours.tools.dialog;

import java.io.IOException;
import java.net.UnknownHostException;

import android.os.AsyncTask;

public class TaiwaServer extends AsyncTask<String, Void, Boolean>  {
	private TaiwaSocket socket;
	private Receiver receiver;

	public TaiwaServer(Receiver receiver) {
		this.receiver = receiver;
	}

	public boolean isConnected()
	{
		if(this.socket==null)
			return false;
		return this.socket.isConnected();
	}

	public void initReceiving()
	{
		this.receive(this.receiver);
	}

	public void send(String sentance) {
		if(socket != null)
			new AsyncTask<String, Integer, String>(){
			@Override
			protected String doInBackground(String... params) {
				socket.send(params[0]);
				return params[0];
			}}.execute(sentance);
	}

	private void receive(final Receiver receiver){
		if(socket == null)
			return;
		new AsyncTask<Void, Integer, String>(){
			@Override
			protected String doInBackground(Void... params) {
				try {
					return socket.read();
				} catch (IOException e) {
					e.printStackTrace();
				}
				return null;
			}
			@Override
			protected void onPostExecute(String result) {
				if(result!=null)
					receiver.receive(result);
				receive(receiver);
			}}.execute();
	}

	@Override
	protected Boolean doInBackground(String... params) {
		try {
			this.socket = new TaiwaSocket(params[0]);
			return true;
		} catch (UnknownHostException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return false;
	}

	public void close() throws IOException {
		if(socket != null)
			this.socket.close();
	}
}
