package kimiko.coreen.app.cours.tools.dialog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

import android.util.Log;

public class TaiwaSocket extends Socket {
	private final static int TIMEOUT = 250;
	private static final String TAG = "TaiwaSocket";
	private static final String SYSTEM_NAME = "tagengo-prod";
	private final static String server = "demo.media.eng.hokudai.ac.jp";
	private final static int port = 12345;
	private BufferedReader in;
	private PrintWriter out;
	
	public TaiwaSocket(String lang) throws UnknownHostException, IOException {
		super(server, port);
		this.in = new BufferedReader(new InputStreamReader(this.getInputStream()));
		this.out = new PrintWriter(this.getOutputStream());
		this.setSoTimeout(TIMEOUT);
		init(lang);
	}
	
	public void init(String lang)
	{
		send(SYSTEM_NAME);
		send(lang);
	}
	
	public void send(String data) {
		Log.v(TAG, "Envoie : " + data);
		this.out.write(data+"\n");
		this.out.flush();
	}
	
	public String read() throws IOException {
		String data = this.in.readLine();
		if(data==null)
			return null;
		
		StringBuilder sb = new StringBuilder();
		while(!data.equals("-request is finished-"))
		{
			sb.append(data);
			Log.v(TAG, "Reception partielle: " + data);
			data = this.in.readLine();
		}
		Log.v(TAG, "Reception : " + sb);
		return sb.toString();
	}

}
