/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.text.TextUtils;
import com.google.analytics.tracking.android.GAUsage;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.Utils;
import java.util.HashMap;
import java.util.Map;

public class MapBuilder {
    private Map<String, String> map = new HashMap<String, String>();

    public MapBuilder set(String paramName, String paramValue) {
        GAUsage.getInstance().setUsage(GAUsage.Field.MAP_BUILDER_SET);
        if (paramName != null) {
            this.map.put(paramName, paramValue);
        } else {
            Log.w(" MapBuilder.set() called with a null paramName.");
        }
        return this;
    }

    public MapBuilder setAll(Map<String, String> params) {
        GAUsage.getInstance().setUsage(GAUsage.Field.MAP_BUILDER_SET_ALL);
        if (params == null) {
            return this;
        }
        this.map.putAll(new HashMap<String, String>(params));
        return this;
    }

    public String get(String paramName) {
        GAUsage.getInstance().setUsage(GAUsage.Field.MAP_BUILDER_GET);
        return this.map.get(paramName);
    }

    public Map<String, String> build() {
        return new HashMap<String, String>(this.map);
    }

    public static MapBuilder createAppView() {
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_APP_VIEW);
        MapBuilder builder = new MapBuilder();
        builder.set("&t", "appview");
        return builder;
    }

    public static MapBuilder createEvent(String category, String action, String label, Long value) {
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_EVENT);
        MapBuilder builder = new MapBuilder();
        builder.set("&t", "event");
        builder.set("&ec", category);
        builder.set("&ea", action);
        builder.set("&el", label);
        builder.set("&ev", value == null ? null : Long.toString(value));
        return builder;
    }

    public static MapBuilder createTransaction(String transactionId, String affiliation, Double revenue, Double tax, Double shipping, String currencyCode) {
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_TRANSACTION);
        MapBuilder builder = new MapBuilder();
        builder.set("&t", "transaction");
        builder.set("&ti", transactionId);
        builder.set("&ta", affiliation);
        builder.set("&tr", revenue == null ? null : Double.toString(revenue));
        builder.set("&tt", tax == null ? null : Double.toString(tax));
        builder.set("&ts", shipping == null ? null : Double.toString(shipping));
        builder.set("&cu", currencyCode);
        return builder;
    }

    public static MapBuilder createItem(String transactionId, String name, String sku, String category, Double price, Long quantity, String currencyCode) {
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_ITEM);
        MapBuilder builder = new MapBuilder();
        builder.set("&t", "item");
        builder.set("&ti", transactionId);
        builder.set("&ic", sku);
        builder.set("&in", name);
        builder.set("&iv", category);
        builder.set("&ip", price == null ? null : Double.toString(price));
        builder.set("&iq", quantity == null ? null : Long.toString(quantity));
        builder.set("&cu", currencyCode);
        return builder;
    }

    public static MapBuilder createException(String exceptionDescription, Boolean fatal) {
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_EXCEPTION);
        MapBuilder builder = new MapBuilder();
        builder.set("&t", "exception");
        builder.set("&exd", exceptionDescription);
        builder.set("&exf", MapBuilder.booleanToString(fatal));
        return builder;
    }

    public static MapBuilder createTiming(String category, Long intervalInMilliseconds, String name, String label) {
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_TIMING);
        MapBuilder builder = new MapBuilder();
        builder.set("&t", "timing");
        builder.set("&utc", category);
        String interval = null;
        if (intervalInMilliseconds != null) {
            interval = Long.toString(intervalInMilliseconds);
        }
        builder.set("&utt", interval);
        builder.set("&utv", name);
        builder.set("&utl", label);
        return builder;
    }

    public static MapBuilder createSocial(String network, String action, String target) {
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_SOCIAL);
        MapBuilder builder = new MapBuilder();
        builder.set("&t", "social");
        builder.set("&sn", network);
        builder.set("&sa", action);
        builder.set("&st", target);
        return builder;
    }

    public MapBuilder setCampaignParamsFromUrl(String utmParams) {
        GAUsage.getInstance().setUsage(GAUsage.Field.MAP_BUILDER_SET_CAMPAIGN_PARAMS);
        String filteredCampaign = Utils.filterCampaign(utmParams);
        if (TextUtils.isEmpty((CharSequence)filteredCampaign)) {
            return this;
        }
        Map<String, String> paramsMap = Utils.parseURLParameters(filteredCampaign);
        this.set("&cc", paramsMap.get("utm_content"));
        this.set("&cm", paramsMap.get("utm_medium"));
        this.set("&cn", paramsMap.get("utm_campaign"));
        this.set("&cs", paramsMap.get("utm_source"));
        this.set("&ck", paramsMap.get("utm_term"));
        this.set("&ci", paramsMap.get("utm_id"));
        this.set("&gclid", paramsMap.get("gclid"));
        this.set("&dclid", paramsMap.get("dclid"));
        this.set("&gmob_t", paramsMap.get("gmob_t"));
        return this;
    }

    static String booleanToString(Boolean b) {
        if (b == null) {
            return null;
        }
        return b != false ? "1" : "0";
    }
}

