/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import android.content.Context;
import com.google.analytics.containertag.proto.Serving;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.Clock;
import com.google.tagmanager.CtfeHost;
import com.google.tagmanager.CustomFunctionCall;
import com.google.tagmanager.EventInfoDistributor;
import com.google.tagmanager.LoadCallback;
import com.google.tagmanager.Log;
import com.google.tagmanager.NoopEventInfoDistributor;
import com.google.tagmanager.PreviewManager;
import com.google.tagmanager.ResourceLoaderSchedulerImpl;
import com.google.tagmanager.ResourceStorageImpl;
import com.google.tagmanager.ResourceUtil;
import com.google.tagmanager.Runtime;
import com.google.tagmanager.TagManager;
import com.google.tagmanager.Types;
import com.google.tagmanager.proto.Resource;
import java.util.HashMap;
import java.util.Map;

public class Container {
    static final long REFRESH_PERIOD_ON_SUCCESS_MS = 43200000L;
    static final long REFRESH_PERIOD_ON_FAILURE_MS = 3600000L;
    static final long MINIMUM_REFRESH_PERIOD_MS = 900000L;
    @VisibleForTesting
    static final int MAX_NUMBER_OF_TOKENS = 30;
    static final int MINIMUM_REFRESH_PERIOD_BURST_MODE_MS = 5000;
    static final boolean ENABLE_CONTAINER_DEBUG_MODE = false;
    private final Context mContext;
    private final String mContainerId;
    private final TagManager mTagManager;
    @VisibleForTesting
    LoadCallback<Serving.Resource> mNetworkLoadCallback;
    @VisibleForTesting
    LoadCallback<Resource.ResourceWithMetadata> mDiskLoadCallback;
    private ResourceStorage mResourceStorage;
    private ResourceLoaderScheduler mNetworkLoadScheduler;
    private Callback mUserCallback;
    private Runtime mRuntime;
    private CtfeHost mCtfeHost = new CtfeHost();
    private Clock mClock;
    private Map<String, FunctionCallMacroHandler> mFunctionCallMacroHandlers;
    private Map<String, FunctionCallTagHandler> mFunctionCallTagHandlers;
    private volatile long mLastRefreshTime;
    private volatile String mCtfeServerAddress;
    private volatile String mCtfeUrlPathAndQuery;
    private volatile String mResourceVersion = "";
    private volatile int mResourceFormatVersion = 0;
    private volatile Serving.Resource mLastLoadedResource;
    private volatile long mLastRefreshMethodCalledTime;
    private volatile int mNumTokens;

    Container(Context context, String containerId, TagManager tagManager) {
        this(context, containerId, tagManager, new ResourceStorageImpl(context, containerId));
    }

    @VisibleForTesting
    Container(Context context, String containerId, TagManager tagManager, ResourceStorage resourceStorage) {
        this.mContext = context;
        this.mContainerId = containerId;
        this.mTagManager = tagManager;
        this.mResourceStorage = resourceStorage;
        this.mNumTokens = 30;
        this.mFunctionCallMacroHandlers = new HashMap<String, FunctionCallMacroHandler>();
        this.mFunctionCallTagHandlers = new HashMap<String, FunctionCallTagHandler>();
        this.createInitialContainer();
    }

    public String getContainerId() {
        return this.mContainerId;
    }

    public boolean getBoolean(String key) {
        Runtime runtime = this.getRuntime();
        if (runtime == null) {
            Log.e("getBoolean called for closed container.");
            return Types.getDefaultBoolean();
        }
        try {
            return Types.valueToBoolean(runtime.evaluateMacroReference(key).getObject());
        }
        catch (Exception e) {
            Log.e("Calling getBoolean() threw an exception: " + e.getMessage() + " Returning default value.");
            return Types.getDefaultBoolean();
        }
    }

    public double getDouble(String key) {
        Runtime runtime = this.getRuntime();
        if (runtime == null) {
            Log.e("getDouble called for closed container.");
            return Types.getDefaultDouble();
        }
        try {
            return Types.valueToDouble(runtime.evaluateMacroReference(key).getObject());
        }
        catch (Exception e) {
            Log.e("Calling getDouble() threw an exception: " + e.getMessage() + " Returning default value.");
            return Types.getDefaultDouble();
        }
    }

    public long getLong(String key) {
        Runtime runtime = this.getRuntime();
        if (runtime == null) {
            Log.e("getLong called for closed container.");
            return Types.getDefaultInt64();
        }
        try {
            return Types.valueToInt64(runtime.evaluateMacroReference(key).getObject());
        }
        catch (Exception e) {
            Log.e("Calling getLong() threw an exception: " + e.getMessage() + " Returning default value.");
            return Types.getDefaultInt64();
        }
    }

    public String getString(String key) {
        Runtime runtime = this.getRuntime();
        if (runtime == null) {
            Log.e("getString called for closed container.");
            return Types.getDefaultString();
        }
        try {
            return Types.valueToString(runtime.evaluateMacroReference(key).getObject());
        }
        catch (Exception e) {
            Log.e("Calling getString() threw an exception: " + e.getMessage() + " Returning default value.");
            return Types.getDefaultString();
        }
    }

    public long getLastRefreshTime() {
        return this.mLastRefreshTime;
    }

    public synchronized void refresh() {
        if (this.getRuntime() == null) {
            Log.w("refresh called for closed container");
            return;
        }
        try {
            if (this.isDefaultContainerRefreshMode()) {
                Log.w("Container is in DEFAULT_CONTAINER mode. Refresh request is ignored.");
                return;
            }
            long currentTime = this.mClock.currentTimeMillis();
            if (this.useAvailableToken(currentTime)) {
                Log.v("Container refresh requested");
                this.loadAfterDelay(0L);
                this.mLastRefreshMethodCalledTime = currentTime;
            } else {
                Log.v("Container refresh was called too often. Ignored.");
            }
        }
        catch (Exception e) {
            Log.e("Calling refresh() throws an exception: " + e.getMessage());
        }
    }

    public synchronized void close() {
        try {
            if (this.mNetworkLoadScheduler != null) {
                this.mNetworkLoadScheduler.close();
            }
            this.mNetworkLoadScheduler = null;
            if (this.mResourceStorage != null) {
                this.mResourceStorage.close();
            }
            this.mResourceStorage = null;
            this.mUserCallback = null;
            this.mTagManager.removeContainer(this.mContainerId);
        }
        catch (Exception e) {
            Log.e("Calling close() threw an exception: " + e.getMessage());
        }
        this.mRuntime = null;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    void load(Callback callback) {
        Clock systemClock = new Clock(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        this.load(callback, new ResourceLoaderSchedulerImpl(this.mContext, this.mContainerId, this.mCtfeHost), systemClock);
    }

    public synchronized void registerFunctionCallMacroHandler(String customMacroName, FunctionCallMacroHandler customMacroHandler) {
        this.mFunctionCallMacroHandlers.put(customMacroName, customMacroHandler);
    }

    public synchronized FunctionCallMacroHandler getFunctionCallMacroHandler(String customMacroName) {
        return this.mFunctionCallMacroHandlers.get(customMacroName);
    }

    public synchronized void registerFunctionCallTagHandler(String customTagName, FunctionCallTagHandler customTagHandler) {
        this.mFunctionCallTagHandlers.put(customTagName, customTagHandler);
    }

    public synchronized FunctionCallTagHandler getFunctionCallTagHandler(String customTagName) {
        return this.mFunctionCallTagHandlers.get(customTagName);
    }

    private synchronized void callRefreshSuccess(RefreshType refreshType) {
        Log.v("calling containerRefreshSuccess(" + (Object)((Object)refreshType) + "): mUserCallback = " + this.mUserCallback);
        if (this.mUserCallback != null) {
            this.mUserCallback.containerRefreshSuccess(this, refreshType);
        }
    }

    private synchronized void callRefreshFailure(RefreshType refreshType, RefreshFailure refreshFailure) {
        if (this.mUserCallback != null) {
            this.mUserCallback.containerRefreshFailure(this, refreshType, refreshFailure);
        }
    }

    private synchronized void callRefreshBegin(RefreshType refreshType) {
        if (this.mUserCallback != null) {
            this.mUserCallback.containerRefreshBegin(this, refreshType);
        }
    }

    @VisibleForTesting
    void evaluateTags(String currentEventName) {
        this.getRuntime().evaluateTags(currentEventName);
    }

    @VisibleForTesting
    synchronized void load(Callback callback, ResourceLoaderScheduler scheduler, final Clock clock) {
        if (this.mDiskLoadCallback != null) {
            throw new RuntimeException("Container already loaded: container ID: " + this.mContainerId);
        }
        this.mClock = clock;
        this.mUserCallback = callback;
        this.mDiskLoadCallback = new LoadCallback<Resource.ResourceWithMetadata>(){

            @Override
            public void startLoad() {
                Container.this.callRefreshBegin(RefreshType.SAVED);
            }

            @Override
            public void onSuccess(Resource.ResourceWithMetadata resource) {
                if (Container.this.isDefault()) {
                    Container.this.initEvaluators(resource.getResource(), false);
                    Log.v("setting refresh time to saved time: " + resource.getTimeStamp());
                    Container.this.mLastRefreshTime = resource.getTimeStamp();
                    Container.this.loadAfterDelay(Math.max(0L, Math.min(43200000L, Container.this.mLastRefreshTime + 43200000L - clock.currentTimeMillis())));
                }
                Container.this.callRefreshSuccess(RefreshType.SAVED);
            }

            @Override
            public void onFailure(LoadCallback.Failure failure) {
                Container.this.callRefreshFailure(RefreshType.SAVED, this.failureToRefreshFailure(failure));
                if (Container.this.isDefault()) {
                    Container.this.loadAfterDelay(0L);
                }
            }

            private RefreshFailure failureToRefreshFailure(LoadCallback.Failure failure) {
                switch (failure) {
                    case NOT_AVAILABLE: {
                        return RefreshFailure.NO_SAVED_CONTAINER;
                    }
                    case IO_ERROR: {
                        return RefreshFailure.IO_ERROR;
                    }
                    case SERVER_ERROR: {
                        return RefreshFailure.SERVER_ERROR;
                    }
                }
                return RefreshFailure.UNKNOWN_ERROR;
            }
        };
        if (this.isDefaultContainerRefreshMode()) {
            Log.i("Container is in DEFAULT_CONTAINER mode. Use default container.");
            return;
        }
        this.mResourceStorage.setLoadCallback(this.mDiskLoadCallback);
        this.mNetworkLoadCallback = new LoadCallback<Serving.Resource>(){

            @Override
            public void startLoad() {
                Container.this.callRefreshBegin(RefreshType.NETWORK);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(Serving.Resource resource) {
                Container container = Container.this;
                synchronized (container) {
                    if (resource != null) {
                        Container.this.initEvaluators(resource, false);
                    } else {
                        if (Container.this.mLastLoadedResource == null) {
                            this.onFailure(LoadCallback.Failure.SERVER_ERROR);
                            return;
                        }
                        resource = Container.this.mLastLoadedResource;
                    }
                    Container.this.mLastRefreshTime = clock.currentTimeMillis();
                    Log.v("setting refresh time to current time: " + Container.this.mLastRefreshTime);
                    if (!Container.this.isContainerPreview()) {
                        Container.this.saveResourceToDisk(resource);
                    }
                    Container.this.loadAfterDelay(43200000L);
                }
                Container.this.callRefreshSuccess(RefreshType.NETWORK);
            }

            @Override
            public void onFailure(LoadCallback.Failure failure) {
                Container.this.loadAfterDelay(3600000L);
                Container.this.callRefreshFailure(RefreshType.NETWORK, this.failureToRefreshFailure(failure));
            }

            private RefreshFailure failureToRefreshFailure(LoadCallback.Failure failure) {
                switch (failure) {
                    case NOT_AVAILABLE: {
                        return RefreshFailure.NO_NETWORK;
                    }
                    case IO_ERROR: {
                        return RefreshFailure.NETWORK_ERROR;
                    }
                    case SERVER_ERROR: {
                        return RefreshFailure.SERVER_ERROR;
                    }
                }
                return RefreshFailure.UNKNOWN_ERROR;
            }
        };
        scheduler.setLoadCallback(this.mNetworkLoadCallback);
        if (this.isContainerPreview()) {
            this.mCtfeUrlPathAndQuery = PreviewManager.getInstance().getCTFEUrlPath();
            scheduler.setCtfeURLPathAndQuery(this.mCtfeUrlPathAndQuery);
        }
        if (this.mCtfeServerAddress != null) {
            this.mCtfeHost.setCtfeServerAddress(this.mCtfeServerAddress);
        }
        this.mNetworkLoadScheduler = scheduler;
        this.mResourceStorage.loadResourceFromDiskInBackground();
    }

    @VisibleForTesting
    String getResourceVersion() {
        return this.mResourceVersion;
    }

    @VisibleForTesting
    synchronized void loadAfterDelay(long delay) {
        if (this.mNetworkLoadScheduler != null && !this.isDefaultContainerRefreshMode()) {
            String previousVersion = this.mLastLoadedResource == null ? null : this.mLastLoadedResource.getVersion();
            this.mNetworkLoadScheduler.loadAfterDelay(delay, previousVersion);
        }
    }

    private synchronized void saveResourceToDisk(Serving.Resource resource) {
        if (this.mResourceStorage != null) {
            this.mResourceStorage.saveResourceToDiskInBackground(Resource.ResourceWithMetadata.newBuilder().setTimeStamp(this.getLastRefreshTime()).setResource(resource).build());
        }
    }

    private void initEvaluators(Serving.Resource resource, boolean isDefaultResource) {
        ResourceUtil.ExpandedResource expandedResource = null;
        try {
            expandedResource = ResourceUtil.getExpandedResource(resource);
        }
        catch (ResourceUtil.InvalidResourceException err) {
            Log.e("Not loading resource: " + resource + " because it is invalid: " + err.toString());
            return;
        }
        if (!isDefaultResource) {
            this.mLastLoadedResource = resource;
        }
        this.initEvaluatorsWithExpandedResource(expandedResource);
    }

    private void initEvaluatorsWithExpandedResource(ResourceUtil.ExpandedResource expandedResource) {
        this.mResourceVersion = expandedResource.getVersion();
        this.mResourceFormatVersion = expandedResource.getResourceFormatVersion();
        EventInfoDistributor eventInfoDistributor = this.createEventInfoDistributor(this.mResourceVersion);
        Runtime runtime = new Runtime(this.mContext, expandedResource, this.mTagManager.getDataLayer(), new FunctionCallMacroHandlerAdapter(), new FunctionCallTagHandlerAdapter(), eventInfoDistributor);
        this.setRuntime(runtime);
    }

    @VisibleForTesting
    EventInfoDistributor createEventInfoDistributor(String resourceVersion) {
        if (PreviewManager.getInstance().getPreviewMode().equals((Object)PreviewManager.PreviewMode.CONTAINER_DEBUG)) {
            // empty if block
        }
        return new NoopEventInfoDistributor();
    }

    private synchronized void setRuntime(Runtime runtime) {
        this.mRuntime = runtime;
    }

    private synchronized Runtime getRuntime() {
        return this.mRuntime;
    }

    @VisibleForTesting
    synchronized void setCtfeServerAddress(String addr) {
        this.mCtfeServerAddress = addr;
        if (addr != null) {
            this.mCtfeHost.setCtfeServerAddress(addr);
        }
    }

    @VisibleForTesting
    synchronized void setCtfeUrlPathAndQuery(String ctfeUrlPathAndQuery) {
        this.mCtfeUrlPathAndQuery = ctfeUrlPathAndQuery;
        if (this.mNetworkLoadScheduler != null) {
            this.mNetworkLoadScheduler.setCtfeURLPathAndQuery(ctfeUrlPathAndQuery);
        }
    }

    String getCtfeUrlPathAndQuery() {
        return this.mCtfeUrlPathAndQuery;
    }

    private boolean isContainerPreview() {
        PreviewManager previewManager = PreviewManager.getInstance();
        return (previewManager.getPreviewMode() == PreviewManager.PreviewMode.CONTAINER || previewManager.getPreviewMode() == PreviewManager.PreviewMode.CONTAINER_DEBUG) && this.mContainerId.equals(previewManager.getContainerId());
    }

    private void createInitialContainer() {
        String containerFile = "tagmanager/" + this.mContainerId;
        Serving.Resource resource = this.mResourceStorage.loadResourceFromContainerAsset(containerFile);
        if (resource != null) {
            this.initEvaluators(resource, true);
            return;
        }
        ResourceUtil.ExpandedResource expandedResource = this.mResourceStorage.loadExpandedResourceFromJsonAsset(containerFile + ".json");
        if (expandedResource == null) {
            Log.w("No default container found; creating an empty container.");
            expandedResource = ResourceUtil.ExpandedResource.newBuilder().build();
        }
        this.initEvaluatorsWithExpandedResource(expandedResource);
    }

    private boolean isDefaultContainerRefreshMode() {
        return this.mTagManager.getRefreshMode() == TagManager.RefreshMode.DEFAULT_CONTAINER;
    }

    private boolean useAvailableToken(long currentTime) {
        if (this.mLastRefreshMethodCalledTime == 0L) {
            --this.mNumTokens;
            return true;
        }
        long timeElapsed = currentTime - this.mLastRefreshMethodCalledTime;
        if (timeElapsed < 5000L) {
            return false;
        }
        if (this.mNumTokens < 30) {
            int numAddedTokens = (int)Math.floor(timeElapsed / 900000L);
            this.mNumTokens = Math.min(30, this.mNumTokens + numAddedTokens);
        }
        if (this.mNumTokens > 0) {
            --this.mNumTokens;
            return true;
        }
        return false;
    }

    static interface ResourceLoaderScheduler {
        public void loadAfterDelay(long var1, String var3);

        public void close();

        public void setLoadCallback(LoadCallback<Serving.Resource> var1);

        public void setCtfeURLPathAndQuery(String var1);
    }

    static interface ResourceStorage {
        public void setLoadCallback(LoadCallback<Resource.ResourceWithMetadata> var1);

        public void loadResourceFromDiskInBackground();

        public void saveResourceToDiskInBackground(Resource.ResourceWithMetadata var1);

        public Serving.Resource loadResourceFromContainerAsset(String var1);

        public ResourceUtil.ExpandedResource loadExpandedResourceFromJsonAsset(String var1);

        public void close();
    }

    private class FunctionCallTagHandlerAdapter
    implements CustomFunctionCall.CustomEvaluator {
        private FunctionCallTagHandlerAdapter() {
        }

        @Override
        public Object evaluate(String key, Map<String, Object> parameters) {
            FunctionCallTagHandler handler = Container.this.getFunctionCallTagHandler(key);
            handler.execute(key, parameters);
            return Types.getDefaultString();
        }
    }

    private class FunctionCallMacroHandlerAdapter
    implements CustomFunctionCall.CustomEvaluator {
        private FunctionCallMacroHandlerAdapter() {
        }

        @Override
        public Object evaluate(String key, Map<String, Object> parameters) {
            FunctionCallMacroHandler handler = Container.this.getFunctionCallMacroHandler(key);
            return handler == null ? null : handler.getValue(key, parameters);
        }
    }

    public static interface FunctionCallTagHandler {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroHandler {
        public Object getValue(String var1, Map<String, Object> var2);
    }

    public static interface Callback {
        public void containerRefreshBegin(Container var1, RefreshType var2);

        public void containerRefreshSuccess(Container var1, RefreshType var2);

        public void containerRefreshFailure(Container var1, RefreshType var2, RefreshFailure var3);
    }

    public static enum RefreshFailure {
        NO_SAVED_CONTAINER,
        IO_ERROR,
        NO_NETWORK,
        NETWORK_ERROR,
        SERVER_ERROR,
        UNKNOWN_ERROR;

    }

    public static enum RefreshType {
        SAVED,
        NETWORK;

    }
}

