/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.analytics.containertag.proto.MutableDebug;
import com.google.analytics.midtier.proto.containertag.MutableTypeSystem;
import com.google.analytics.midtier.proto.containertag.TypeSystem;
import com.google.tagmanager.DebugMacroEvaluationInfoBuilder;
import com.google.tagmanager.Log;
import com.google.tagmanager.MacroEvaluationInfoBuilder;
import com.google.tagmanager.ValueBuilder;

class DebugValueBuilder
implements ValueBuilder {
    private MutableTypeSystem.Value value;

    public DebugValueBuilder(MutableTypeSystem.Value value) {
        this.value = value;
    }

    private void validateType(MutableTypeSystem.Value.Type expected, MutableTypeSystem.Value.Type actual, String message) {
        if (!expected.equals(actual)) {
            throw new TypeMismatchException(message, actual);
        }
    }

    public static MutableTypeSystem.Value copyImmutableValue(TypeSystem.Value value) {
        MutableTypeSystem.Value result = MutableTypeSystem.Value.newMessage();
        if (result.mergeFrom(value.toByteArray()) == false) {
            Log.e("Failed to copy runtime value into debug value");
        }
        return result;
    }

    @Override
    public ValueBuilder getListItem(int index) {
        this.validateType(MutableTypeSystem.Value.Type.LIST, this.value.getType(), "add new list item");
        DebugValueBuilder listItemBuilder = new DebugValueBuilder(this.value.getListItem(index));
        return listItemBuilder;
    }

    @Override
    public ValueBuilder getMapKey(int index) {
        this.validateType(MutableTypeSystem.Value.Type.MAP, this.value.getType(), "add new map key");
        DebugValueBuilder mapKeyValueBuilder = new DebugValueBuilder(this.value.getMapKey(index));
        return mapKeyValueBuilder;
    }

    @Override
    public ValueBuilder getMapValue(int index) {
        this.validateType(MutableTypeSystem.Value.Type.MAP, this.value.getType(), "add new map value");
        DebugValueBuilder mapValueBuilder = new DebugValueBuilder(this.value.getMapValue(index));
        return mapValueBuilder;
    }

    @Override
    public ValueBuilder getTemplateToken(int index) {
        this.validateType(MutableTypeSystem.Value.Type.TEMPLATE, this.value.getType(), "add template token");
        DebugValueBuilder tokenValueBuilder = new DebugValueBuilder(this.value.getTemplateToken(index));
        return tokenValueBuilder;
    }

    @Override
    public MacroEvaluationInfoBuilder createValueMacroEvaluationInfoExtension() {
        this.validateType(MutableTypeSystem.Value.Type.MACRO_REFERENCE, this.value.getType(), "set macro evaluation extension");
        DebugMacroEvaluationInfoBuilder macroEvaluationExtension = new DebugMacroEvaluationInfoBuilder(this.value.getMutableExtension(MutableDebug.MacroEvaluationInfo.macro));
        return macroEvaluationExtension;
    }

    private static class TypeMismatchException
    extends IllegalStateException {
        public TypeMismatchException(String operation, MutableTypeSystem.Value.Type t) {
            super("Attempted operation: " + operation + " on object of type: " + t);
        }
    }
}

