/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.NetworkClient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

class HttpUrlConnectionNetworkClient
implements NetworkClient {
    private HttpURLConnection mConnection;

    HttpUrlConnectionNetworkClient() {
    }

    @Override
    public InputStream getInputStream(String urlStr) throws IOException {
        this.mConnection = this.getUrlConnection(urlStr);
        return this.handleServerResponse(this.mConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPostRequest(String urlStr, byte[] content) throws IOException {
        HttpURLConnection connection = this.getUrlConnection(urlStr);
        try {
            connection.setRequestProperty("Content-Length", Integer.toString(content.length));
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.connect();
            OutputStream sendToServer = connection.getOutputStream();
            try {
                sendToServer.write(content);
                sendToServer.flush();
            }
            finally {
                sendToServer.close();
            }
            this.handleServerResponse(connection);
        }
        finally {
            this.closeURLConnection(connection);
        }
    }

    private InputStream handleServerResponse(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            return connection.getInputStream();
        }
        String errorMessage = "Bad response: " + responseCode;
        if (responseCode == 404) {
            throw new FileNotFoundException(errorMessage);
        }
        throw new IOException(errorMessage);
    }

    @Override
    public void close() {
        this.closeURLConnection(this.mConnection);
    }

    private void closeURLConnection(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    @VisibleForTesting
    HttpURLConnection getUrlConnection(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setReadTimeout(20000);
        connection.setConnectTimeout(20000);
        return connection;
    }
}

