/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.Clock;
import com.google.tagmanager.Dispatcher;
import com.google.tagmanager.FutureApis;
import com.google.tagmanager.Hit;
import com.google.tagmanager.HitStore;
import com.google.tagmanager.HitStoreStateListener;
import com.google.tagmanager.Log;
import com.google.tagmanager.ServiceManagerImpl;
import com.google.tagmanager.SimpleNetworkDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class PersistentHitStore
implements HitStore {
    @VisibleForTesting
    static final String HIT_ID = "hit_id";
    @VisibleForTesting
    static final String HIT_TIME = "hit_time";
    @VisibleForTesting
    static final String HIT_URL = "hit_url";
    @VisibleForTesting
    static final String HIT_FIRST_DISPATCH_TIME = "hit_first_send_time";
    @VisibleForTesting
    static final String HITS_TABLE = "gtm_hits";
    static final long HIT_DISPATCH_RETRY_WINDOW = 14400000L;
    private static final String CREATE_HITS_TABLE = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL,'%s' INTEGER NOT NULL);", "gtm_hits", "hit_id", "hit_time", "hit_url", "hit_first_send_time");
    private static final String HIT_ID_WHERE_CLAUSE = "hit_id=?";
    private static final String DATABASE_FILENAME = "gtm_urls.db";
    private final UrlDatabaseHelper mDbHelper;
    private volatile Dispatcher mDispatcher;
    private final HitStoreStateListener mListener;
    private final Context mContext;
    private final String mDatabaseName;
    private long mLastDeleteStaleHitsTime;
    private Clock mClock;

    PersistentHitStore(HitStoreStateListener listener, Context ctx) {
        this(listener, ctx, DATABASE_FILENAME);
    }

    @VisibleForTesting
    PersistentHitStore(HitStoreStateListener listener, Context ctx, String databaseName) {
        this.mContext = ctx.getApplicationContext();
        this.mDatabaseName = databaseName;
        this.mListener = listener;
        this.mClock = new Clock(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        this.mDbHelper = new UrlDatabaseHelper(this.mContext, this.mDatabaseName);
        this.mDispatcher = new SimpleNetworkDispatcher((HttpClient)new DefaultHttpClient(), this.mContext, new StoreDispatchListener());
        this.mLastDeleteStaleHitsTime = 0L;
    }

    @VisibleForTesting
    public void setClock(Clock clock) {
        this.mClock = clock;
    }

    @VisibleForTesting
    public UrlDatabaseHelper getDbHelper() {
        return this.mDbHelper;
    }

    @VisibleForTesting
    void setDispatcher(Dispatcher dispatcher) {
        this.mDispatcher = dispatcher;
    }

    @Override
    public void putHit(long hitTimeInMilliseconds, String path) {
        this.deleteStaleHits();
        this.removeOldHitIfFull();
        this.writeHitToDatabase(hitTimeInMilliseconds, path);
    }

    private void removeOldHitIfFull() {
        int hitsOverLimit = this.getNumStoredHits() - 2000 + 1;
        if (hitsOverLimit > 0) {
            List<String> hitsToDelete = this.peekHitIds(hitsOverLimit);
            Log.v("Store full, deleting " + hitsToDelete.size() + " hits to make room.");
            this.deleteHits(hitsToDelete.toArray(new String[0]));
        }
    }

    private void writeHitToDatabase(long hitTimeInMilliseconds, String path) {
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for putHit");
        if (db == null) {
            return;
        }
        ContentValues content = new ContentValues();
        content.put(HIT_TIME, Long.valueOf(hitTimeInMilliseconds));
        content.put(HIT_URL, path);
        content.put(HIT_FIRST_DISPATCH_TIME, Integer.valueOf(0));
        try {
            db.insert(HITS_TABLE, null, content);
            this.mListener.reportStoreIsEmpty(false);
        }
        catch (SQLiteException e) {
            Log.w("Error storing hit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> peekHitIds(int maxHits) {
        ArrayList<String> hitIds = new ArrayList<String>();
        if (maxHits <= 0) {
            Log.w("Invalid maxHits specified. Skipping");
            return hitIds;
        }
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for peekHitIds.");
        if (db == null) {
            return hitIds;
        }
        Cursor cursor = null;
        try {
            cursor = db.query(HITS_TABLE, new String[]{HIT_ID}, null, null, null, null, String.format("%s ASC", HIT_ID), Integer.toString(maxHits));
            if (cursor.moveToFirst()) {
                do {
                    hitIds.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException e) {
            Log.w("Error in peekHits fetching hitIds: " + e.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return hitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Hit> peekHits(int maxHits) {
        ArrayList<Hit> hits = new ArrayList<Hit>();
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for peekHits");
        if (db == null) {
            return hits;
        }
        Cursor cursor = null;
        try {
            cursor = db.query(HITS_TABLE, new String[]{HIT_ID, HIT_TIME, HIT_FIRST_DISPATCH_TIME}, null, null, null, null, String.format("%s ASC", HIT_ID), Integer.toString(maxHits));
            hits = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    Hit hit = new Hit(cursor.getLong(0), cursor.getLong(1), cursor.getLong(2));
                    hits.add(hit);
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException e) {
            Log.w("Error in peekHits fetching hitIds: " + e.getMessage());
            ArrayList<Hit> arrayList = hits;
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        int count = 0;
        try {
            CursorWindow cw;
            cursor = db.query(HITS_TABLE, new String[]{HIT_ID, HIT_URL}, null, null, null, null, String.format("%s ASC", HIT_ID), Integer.toString(maxHits));
            if (cursor.moveToFirst()) {
                do {
                    if ((cw = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((Hit)hits.get(count)).setHitUrl(cursor.getString(1));
                    } else {
                        Log.w(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((Hit)hits.get(count)).getHitId()));
                    }
                    ++count;
                } while (cursor.moveToNext());
            }
            cw = hits;
            return cw;
        }
        catch (SQLiteException e) {
            Log.w("Error in peekHits fetching hit url: " + e.getMessage());
            ArrayList<Hit> partialHits = new ArrayList<Hit>();
            boolean foundOneBadHit = false;
            for (Hit hit : hits) {
                if (TextUtils.isEmpty((CharSequence)hit.getHitUrl())) {
                    if (foundOneBadHit) break;
                    foundOneBadHit = true;
                }
                partialHits.add(hit);
            }
            ArrayList<Hit> arrayList = partialHits;
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @VisibleForTesting
    void setLastDeleteStaleHitsTime(long timeInMilliseconds) {
        this.mLastDeleteStaleHitsTime = timeInMilliseconds;
    }

    int deleteStaleHits() {
        long now = this.mClock.currentTimeMillis();
        if (now <= this.mLastDeleteStaleHitsTime + 86400000L) {
            return 0;
        }
        this.mLastDeleteStaleHitsTime = now;
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for deleteStaleHits.");
        if (db == null) {
            return 0;
        }
        long lastGoodTime = this.mClock.currentTimeMillis() - 2592000000L;
        int rslt = db.delete(HITS_TABLE, "HIT_TIME < ?", new String[]{Long.toString(lastGoodTime)});
        this.mListener.reportStoreIsEmpty(this.getNumStoredHits() == 0);
        return rslt;
    }

    void deleteHits(String[] hitIds) {
        if (hitIds == null || hitIds.length == 0) {
            return;
        }
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for deleteHits.");
        if (db == null) {
            return;
        }
        String whereClause = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(hitIds.length, "?")));
        try {
            db.delete(HITS_TABLE, whereClause, hitIds);
            this.mListener.reportStoreIsEmpty(this.getNumStoredHits() == 0);
        }
        catch (SQLiteException e) {
            Log.w("Error deleting hits");
        }
    }

    private void deleteHit(long hitId) {
        this.deleteHits(new String[]{String.valueOf(hitId)});
    }

    private void setHitFirstDispatchTime(long hitId, long firstDispatchTime) {
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for getNumStoredHits.");
        if (db == null) {
            return;
        }
        ContentValues cv = new ContentValues();
        cv.put(HIT_FIRST_DISPATCH_TIME, Long.valueOf(firstDispatchTime));
        try {
            db.update(HITS_TABLE, cv, HIT_ID_WHERE_CLAUSE, new String[]{String.valueOf(hitId)});
        }
        catch (SQLiteException e) {
            Log.w("Error setting HIT_FIRST_DISPATCH_TIME for hitId: " + hitId);
            this.deleteHit(hitId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumStoredHits() {
        int numStoredHits = 0;
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for getNumStoredHits.");
        if (db == null) {
            return numStoredHits;
        }
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("SELECT COUNT(*) from gtm_hits", null);
            if (cursor.moveToFirst()) {
                numStoredHits = (int)cursor.getLong(0);
            }
        }
        catch (SQLiteException e) {
            Log.w("Error getting numStoredHits");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return numStoredHits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumStoredUntriedHits() {
        int numStoredHits = 0;
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for getNumStoredHits.");
        if (db == null) {
            return numStoredHits;
        }
        Cursor cursor = null;
        try {
            cursor = db.query(HITS_TABLE, new String[]{HIT_ID, HIT_FIRST_DISPATCH_TIME}, "hit_first_send_time=0", null, null, null, null);
            numStoredHits = cursor.getCount();
        }
        catch (SQLiteException e) {
            Log.w("Error getting num untried hits");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return numStoredHits;
    }

    @Override
    public void dispatch() {
        Log.v("GTM Dispatch running...");
        if (!this.mDispatcher.okToDispatch()) {
            return;
        }
        List<Hit> hits = this.peekHits(40);
        if (hits.isEmpty()) {
            Log.v("...nothing to dispatch");
            this.mListener.reportStoreIsEmpty(true);
            return;
        }
        this.mDispatcher.dispatchHits(hits);
        if (this.getNumStoredUntriedHits() > 0) {
            ServiceManagerImpl.getInstance().dispatch();
        }
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.mDispatcher;
    }

    @Override
    public void close() {
        try {
            this.mDbHelper.getWritableDatabase().close();
            this.mDispatcher.close();
        }
        catch (SQLiteException e) {
            Log.w("Error opening database for close");
            return;
        }
    }

    @VisibleForTesting
    UrlDatabaseHelper getHelper() {
        return this.mDbHelper;
    }

    private SQLiteDatabase getWritableDatabase(String errorMessage) {
        SQLiteDatabase db = null;
        try {
            db = this.mDbHelper.getWritableDatabase();
        }
        catch (SQLiteException e) {
            Log.w(errorMessage);
            return null;
        }
        return db;
    }

    @VisibleForTesting
    class UrlDatabaseHelper
    extends SQLiteOpenHelper {
        private boolean mBadDatabase;
        private long mLastDatabaseCheckTime;

        boolean isBadDatabase() {
            return this.mBadDatabase;
        }

        void setBadDatabase(boolean badDatabase) {
            this.mBadDatabase = badDatabase;
        }

        UrlDatabaseHelper(Context context, String databaseName) {
            super(context, databaseName, null, 1);
            this.mLastDatabaseCheckTime = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tablePresent(String table, SQLiteDatabase db) {
            Cursor cursor = null;
            try {
                cursor = db.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{table}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
            catch (SQLiteException e) {
                Log.w("Error querying for table " + table);
                boolean bl = false;
                return bl;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.mBadDatabase && this.mLastDatabaseCheckTime + 3600000L > PersistentHitStore.this.mClock.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase db = null;
            this.mBadDatabase = true;
            this.mLastDatabaseCheckTime = PersistentHitStore.this.mClock.currentTimeMillis();
            try {
                db = super.getWritableDatabase();
            }
            catch (SQLiteException e) {
                PersistentHitStore.this.mContext.getDatabasePath(PersistentHitStore.this.mDatabaseName).delete();
            }
            if (db == null) {
                db = super.getWritableDatabase();
            }
            this.mBadDatabase = false;
            return db;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db) {
            if (Build.VERSION.SDK_INT < 15) {
                Cursor cursor = db.rawQuery("PRAGMA journal_mode=memory", null);
                try {
                    cursor.moveToFirst();
                }
                finally {
                    cursor.close();
                }
            }
            if (!this.tablePresent(PersistentHitStore.HITS_TABLE, db)) {
                db.execSQL(CREATE_HITS_TABLE);
            } else {
                this.validateColumnsPresent(db);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateColumnsPresent(SQLiteDatabase db) {
            Cursor c = db.rawQuery("SELECT * FROM gtm_hits WHERE 0", null);
            HashSet<String> columns = new HashSet<String>();
            try {
                String[] columnNames = c.getColumnNames();
                for (int i = 0; i < columnNames.length; ++i) {
                    columns.add(columnNames[i]);
                }
            }
            finally {
                c.close();
            }
            if (!(columns.remove(PersistentHitStore.HIT_ID) && columns.remove(PersistentHitStore.HIT_URL) && columns.remove(PersistentHitStore.HIT_TIME) && columns.remove(PersistentHitStore.HIT_FIRST_DISPATCH_TIME))) {
                throw new SQLiteException("Database column missing");
            }
            if (!columns.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase db) {
            FutureApis.setOwnerOnlyReadWrite(db.getPath());
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }

    @VisibleForTesting
    class StoreDispatchListener
    implements SimpleNetworkDispatcher.DispatchListener {
        StoreDispatchListener() {
        }

        @Override
        public void onHitDispatched(Hit hit) {
            PersistentHitStore.this.deleteHit(hit.getHitId());
        }

        @Override
        public void onHitPermanentDispatchFailure(Hit hit) {
            PersistentHitStore.this.deleteHit(hit.getHitId());
            Log.v("Permanent failure dispatching hitId: " + hit.getHitId());
        }

        @Override
        public void onHitTransientDispatchFailure(Hit hit) {
            long firstDispatchTime = hit.getHitFirstDispatchTime();
            if (firstDispatchTime == 0L) {
                PersistentHitStore.this.setHitFirstDispatchTime(hit.getHitId(), PersistentHitStore.this.mClock.currentTimeMillis());
            } else if (firstDispatchTime + 14400000L < PersistentHitStore.this.mClock.currentTimeMillis()) {
                PersistentHitStore.this.deleteHit(hit.getHitId());
                Log.v("Giving up on failed hitId: " + hit.getHitId());
            }
        }
    }
}

