/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import android.content.Context;
import android.net.Uri;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.AdwordsClickReferrerListener;
import com.google.tagmanager.Container;
import com.google.tagmanager.DataLayer;
import com.google.tagmanager.Log;
import com.google.tagmanager.PreviewManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TagManager {
    private final ContainerProvider mContainerProvider;
    private final Context mContext;
    private final DataLayer mDataLayer;
    private volatile RefreshMode mRefreshMode;
    private volatile String mCtfeServerAddr;
    private final ConcurrentMap<String, Container> mContainers;
    private static TagManager sInstance;

    @VisibleForTesting
    TagManager(Context context, ContainerProvider containerProvider, DataLayer dataLayer) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.mContainerProvider = containerProvider;
        this.mRefreshMode = RefreshMode.STANDARD;
        this.mContainers = new ConcurrentHashMap<String, Container>();
        this.mDataLayer = dataLayer;
        this.mDataLayer.registerListener(new DataLayer.Listener(){

            @Override
            public void changed(Map<Object, Object> update) {
                Object eventValue = update.get("event");
                if (eventValue != null) {
                    TagManager.this.refreshTagsInAllContainers(eventValue.toString());
                }
            }
        });
        this.mDataLayer.registerListener(new AdwordsClickReferrerListener(this.mContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TagManager getInstance(Context context) {
        Class<TagManager> clazz = TagManager.class;
        synchronized (TagManager.class) {
            if (sInstance == null) {
                ContainerProvider provider = new ContainerProvider(){

                    @Override
                    public Container newContainer(Context context, String containerId, TagManager tagManager) {
                        return new Container(context, containerId, tagManager);
                    }
                };
                sInstance = new TagManager(context, provider, new DataLayer());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public DataLayer getDataLayer() {
        return this.mDataLayer;
    }

    public Container openContainer(String containerId, Container.Callback callback) {
        Container container = this.mContainerProvider.newContainer(this.mContext, containerId, this);
        if (this.mContainers.putIfAbsent(containerId, container) != null) {
            throw new IllegalArgumentException("Container id:" + containerId + " has already been opened.");
        }
        if (this.mCtfeServerAddr != null) {
            container.setCtfeServerAddress(this.mCtfeServerAddr);
        }
        container.load(callback);
        return container;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setLogger(com.google.tagmanager.Logger logger) {
        Log.setLogger(logger);
    }

    public com.google.tagmanager.Logger getLogger() {
        return Log.getLogger();
    }

    public void setRefreshMode(RefreshMode mode) {
        this.mRefreshMode = mode;
    }

    public RefreshMode getRefreshMode() {
        return this.mRefreshMode;
    }

    public Container getContainer(String containerId) {
        return (Container)this.mContainers.get(containerId);
    }

    synchronized boolean setPreviewData(Uri data) {
        PreviewManager previewManager = PreviewManager.getInstance();
        if (previewManager.setPreviewData(data)) {
            String previewContainerId = previewManager.getContainerId();
            switch (previewManager.getPreviewMode()) {
                case NONE: {
                    Container exitPreviewContainer = (Container)this.mContainers.get(previewContainerId);
                    if (exitPreviewContainer == null) break;
                    exitPreviewContainer.setCtfeUrlPathAndQuery(null);
                    exitPreviewContainer.refresh();
                    break;
                }
                case CONTAINER: 
                case CONTAINER_DEBUG: {
                    for (Map.Entry entry : this.mContainers.entrySet()) {
                        Container container = (Container)entry.getValue();
                        if (((String)entry.getKey()).equals(previewContainerId)) {
                            container.setCtfeUrlPathAndQuery(previewManager.getCTFEUrlPath());
                            container.refresh();
                            continue;
                        }
                        if (container.getCtfeUrlPathAndQuery() == null) continue;
                        container.setCtfeUrlPathAndQuery(null);
                        container.refresh();
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void setCtfeServerAddress(String addr) {
        this.mCtfeServerAddr = addr;
    }

    boolean removeContainer(String containerId) {
        return this.mContainers.remove(containerId) != null;
    }

    private void refreshTagsInAllContainers(String eventName) {
        for (Container container : this.mContainers.values()) {
            container.evaluateTags(eventName);
        }
    }

    @Deprecated
    public static interface Logger
    extends com.google.tagmanager.Logger {
    }

    @VisibleForTesting
    static interface ContainerProvider {
        public Container newContainer(Context var1, String var2, TagManager var3);
    }

    static class ContainerOpenException
    extends RuntimeException {
        private final String mContainerId;

        private ContainerOpenException(String containerId) {
            super("Container already open: " + containerId);
            this.mContainerId = containerId;
        }

        public String getContainerId() {
            return this.mContainerId;
        }
    }

    public static enum RefreshMode {
        STANDARD,
        DEFAULT_CONTAINER;

    }
}

