package app.hima.activity;

import com.google.analytics.tracking.android.EasyTracker;

import android.os.Bundle;
import android.app.Activity;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ListView;
import android.widget.SearchView;
import android.widget.SearchView.OnQueryTextListener;
import android.support.v4.app.NavUtils;
import app.hima.R;
import app.hima.net.SendUserMessage;
import app.hima.tool.MessageAdapter;
import app.hima.tool.UserMessageAdapter;

public class MessageActivity extends Activity {

	private SearchView search;
	private ListView listView;
	private MessageAdapter adapter;
	private Update update;

	private class Update extends Thread {
		private final static int TIME = 30 * 1000;
		private boolean stop = false;
		
		public void setStop() {
			this.stop = true;
		}

		@Override
		public void run() {
			while (!stop) {
				synchronized (this) {
					runOnUiThread(new Runnable() {
						public void run() {
							adapter.reload();
						}
					});
					try {
						wait(TIME);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
		}

	}

	@Override
	  public void onStart() {
	    super.onStart();
	    EasyTracker.getInstance(this).activityStart(this);  // Add this method.
	  }

	  @Override
	  public void onStop() {
	    super.onStop();
	    EasyTracker.getInstance(this).activityStop(this);  // Add this method.
	  }
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_message);
		setupActionBar();

		final Bundle bundle = getIntent().getExtras();
		final int coid;
		if (bundle != null)
			coid = bundle.getInt("user");
		else
			coid = 0;

		this.search = (SearchView) findViewById(R.id.messageWrite);
		this.listView = (ListView) findViewById(R.id.messageList);

		this.search.setOnQueryTextListener(new OnQueryTextListener() {

			@Override
			public boolean onQueryTextSubmit(String query) {
				if (query == null || query == "")
					return false;
				new SendUserMessage().execute(query, String.valueOf(coid));
				adapter.reload();
				search.setQuery("", false);
				return true;
			}

			@Override
			public boolean onQueryTextChange(String newText) {
				return false;
			}
		});

		this.adapter = new UserMessageAdapter(this, coid);

		Button reload = new Button(this);
		reload.setText("更新");
		reload.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				adapter.reload();
			}
		});
		this.listView.addHeaderView(reload);

		this.listView.setAdapter(this.adapter);
		//this.adapter.reload();
	}

	@Override
	protected void onResume() {
		super.onResume();
		this.update = new Update();
		this.update.start();
	}

	@Override
	protected void onPause() {
		this.update.setStop();
		super.onPause();
	}

	/**
	 * Set up the {@link android.app.ActionBar}.
	 */
	private void setupActionBar() {
		getActionBar().setDisplayHomeAsUpEnabled(true);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.message, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case android.R.id.home:
			NavUtils.navigateUpFromSameTask(this);

			return true;
		}
		return super.onOptionsItemSelected(item);
	}

}
