package app.hima.activity;

import com.google.analytics.tracking.android.EasyTracker;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.NavUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.QuickContactBadge;
import android.widget.TextView;
import app.hima.R;
import app.hima.activity.tools.SetProfil;
import app.hima.data.Profil;
import app.hima.net.GetProfile;
import app.hima.net.SetImage;
import app.hima.net.SetImageSmall;

public class ProfilActivity extends Activity implements SetProfil {

	private static final class ImageShow implements OnClickListener {
		private final int id, no;
		private final Activity moi;

		private ImageShow(int id, int no, Activity moi) {
			this.id = id;
			this.no = no;
			this.moi = moi;
		}

		@Override
		public void onClick(View v) {
			ImageView iv = new ImageView(moi);
			new SetImage(iv).execute(id + "-" + no + ".jpg");
			new AlertDialog.Builder(moi).setView(iv).show();
		}
	}

	@Override
	  public void onStart() {
	    super.onStart();
	    EasyTracker.getInstance(this).activityStart(this);  // Add this method.
	  }

	  @Override
	  public void onStop() {
	    super.onStop();
	    EasyTracker.getInstance(this).activityStop(this);  // Add this method.
	  }
	
	private QuickContactBadge badge;
	private TextView name, sex, place, profil, age;
	private ImageButton image1, image2, image3, image4, image5;
	private Button send;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_profil);

		final Bundle bundle = getIntent().getExtras();
		final int id;
		if (bundle != null)
			id = bundle.getInt("user");
		else
			id = 0;

		this.badge = (QuickContactBadge) findViewById(R.id.profilBadge);
		this.name = (TextView) findViewById(R.id.profilName);
		this.place = (TextView) findViewById(R.id.profilPlace);
		this.sex = (TextView) findViewById(R.id.profilSex);
		this.age = (TextView) findViewById(R.id.profilAge);
		this.profil = (TextView) findViewById(R.id.profilProfil);

		this.image1 = (ImageButton) findViewById(R.id.profilImage1);
		this.image2 = (ImageButton) findViewById(R.id.profilImage2);
		this.image3 = (ImageButton) findViewById(R.id.profilImage3);
		this.image4 = (ImageButton) findViewById(R.id.profilImage4);
		this.image5 = (ImageButton) findViewById(R.id.profilImage5);

		new SetImageSmall(this.badge).execute(id + "-0.jpg");

		new SetImageSmall(this.image1).execute(id + "-1.jpg");
		new SetImageSmall(this.image2).execute(id + "-2.jpg");
		new SetImageSmall(this.image3).execute(id + "-3.jpg");
		new SetImageSmall(this.image4).execute(id + "-4.jpg");
		new SetImageSmall(this.image5).execute(id + "-5.jpg");

		this.send = (Button) findViewById(R.id.profilSendButton);
		final Activity moi = this;

		this.send.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				Intent myIntent = new Intent(moi, MessageActivity.class);
				myIntent.putExtras(bundle);
				moi.startActivity(myIntent);
			}
		});

		new GetProfile(this).execute(id);

		this.badge.setOnClickListener(new ImageShow(id, 0, moi));
		this.image1.setOnClickListener(new ImageShow(id, 1, moi));
		this.image2.setOnClickListener(new ImageShow(id, 2, moi));
		this.image3.setOnClickListener(new ImageShow(id, 3, moi));
		this.image4.setOnClickListener(new ImageShow(id, 4, moi));
		this.image5.setOnClickListener(new ImageShow(id, 5, moi));

		setupActionBar();
	}

	@Override
	public void setProfil(Profil profil) {
		if (profil != null) {
			this.name.setText(profil.getName());
			this.age.setText(profil.getAge());
			this.sex.setText(profil.getSex().equals("1") ? "女" : "男");
			this.place.setText(profil.getPlace());
			this.profil.setText(profil.getProfile());
		}
	}

	private void setupActionBar() {
		getActionBar().setDisplayHomeAsUpEnabled(true);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.message, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case android.R.id.home:
			NavUtils.navigateUpFromSameTask(this);
			return true;
		}
		return super.onOptionsItemSelected(item);
	}
}
