package app.hima.activity.fragment;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ListView;
import app.hima.R;
import app.hima.tool.MessageAdapter;
import app.hima.tool.UserMessageAdapter;

public class MessageFragment extends Fragment {

		private ListView listView;
		private MessageAdapter adapter;

		@Override
		public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
			View rootView = inflater.inflate(R.layout.fragment_message,	container, false);
			this.listView = (ListView) rootView.findViewById(R.id.messageList);
			this.adapter = new UserMessageAdapter(getActivity());
			
			Button reload = new Button(getActivity());
			reload.setText("更新");
			reload.setOnClickListener(new OnClickListener() {
				
				@Override
				public void onClick(View v) {
					adapter.reload();
				}
			});
			this.listView.addHeaderView(reload);

			this.listView.setAdapter(this.adapter);
			this.adapter.reload();
			
			return rootView;
		}
}
