package app.hima.net;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import android.os.AsyncTask;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.widget.Toast;
import app.hima.data.Profil;
import app.hima.tool.Buffer;

public class UpdateProfile extends AsyncTask<Profil, Integer, Boolean> {
	private FragmentActivity activity;

	public UpdateProfile(FragmentActivity activity) {
		this.activity = activity;
	}

	@Override
	protected Boolean doInBackground(Profil... params) {
		Profil profil = params[0];
		try {
			String URL = ServerRequest.SERVER + "updateUser.pl?id="+ profil.getId() +
					"&name=" +URLEncoder.encode(profil.getName(), "UTF-8")+
					"&sex=" +URLEncoder.encode(profil.getSex(), "UTF-8")+
					"&age=" +profil.getAge()+
					"&place=" +URLEncoder.encode(profil.getPlace(), "UTF-8")+
					"&profile=" +URLEncoder.encode(profil.getProfile(), "UTF-8");
			Log.d(this.getClass().getSimpleName(), URL);
			ServerRequest.send(URL);
			
			String tURL = ServerRequest.SERVER + "getUser.pl?id="+ profil.getId();
	        Buffer.setProfil(tURL, profil);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return false;
		}
        return true;
	}
	
	@Override
	protected void onPostExecute(Boolean result) {
		if(result)
			Toast.makeText(activity, "プロフィールを保存しました。", Toast.LENGTH_SHORT).show();
		else
			Toast.makeText(activity, "プロフィールを保存できませんでした。", Toast.LENGTH_SHORT).show();
    }
}
