package app.hima.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.QuickContactBadge;
import android.widget.TextView;
import app.hima.R;
import app.hima.activity.MessageActivity;
import app.hima.activity.ProfilActivity;
import app.hima.data.Message;
import app.hima.net.GetMessage;
import app.hima.net.GetName;
import app.hima.net.SetImageSmall;

public class MessageAdapter extends BaseAdapter {
	protected LayoutInflater inflater;
	protected List<Message> messages;
	private AsyncTask<Integer, Integer, List<Message>> getMessage;

	public MessageAdapter(Context context) {
		this.inflater = LayoutInflater.from(context);
		this.messages = new ArrayList<Message>();
	}
	
	protected void load() throws ExecutionException, InterruptedException {
		this.getMessage = new GetMessage(this).execute();
	}
	
	protected void setRead(int id) {
	}
	
	public void reload() {
		if(getMessage != null)
			getMessage.cancel(true);
		
		try {
			load();
		} catch (ExecutionException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	public Context getContext() {
		return inflater.getContext();
	}
	
	@Override
	public int getCount() {
		return this.messages.size();
	}

	@Override
	public Object getItem(int position) {
		return this.messages.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}
	
	private class ViewHolder {
		TextView name;
		TextView message;
		QuickContactBadge badge;
	}
	
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		ViewHolder holder;

		if(convertView == null) {
			holder = new ViewHolder();
			convertView = inflater.inflate(R.layout.message, null);
			holder.name = (TextView)convertView.findViewById(R.id.messageUserName);
			holder.message = (TextView)convertView.findViewById(R.id.messageMessage);
			holder.badge = (QuickContactBadge)convertView.findViewById(R.id.messageBadge);
			
			convertView.setTag(holder);
		} else {
			holder = (ViewHolder) convertView.getTag();
		}

		final int id = this.messages.get(position).getUser();
		
		new GetName(holder.name).execute(id);
		
		holder.name.setText(String.valueOf(id));
		holder.message.setText(this.messages.get(position).getMessage());
		holder.badge.setImageToDefault();
		
		if(!this.messages.get(position).isRead() && this.messages.get(position).getUser() != Preferences.id)
		{
			convertView.setBackgroundColor(Color.LTGRAY);
			setRead(this.messages.get(position).getId());
		}
		
		new SetImageSmall(holder.badge).execute(id+"-0.jpg");
		
		final Bundle b = new Bundle();
		b.putInt("user", id);
		
		holder.badge.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent myIntent = new Intent(inflater.getContext(), ProfilActivity.class);
				myIntent.putExtras(b);
				inflater.getContext().startActivity(myIntent);
			}
		});
		
		convertView.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent myIntent = new Intent(inflater.getContext(), MessageActivity.class);
				myIntent.putExtras(b);
				inflater.getContext().startActivity(myIntent);
			}
		});

		return convertView;
	}

	public List<Message> getMessages() {
		return messages;
	}

	public void setMessages(List<Message> messages) {
		this.messages = messages;
	}
}
