package app.hima.tool;

import java.util.concurrent.ExecutionException;

import android.content.Context;
import android.widget.Toast;
import app.hima.net.GetUserMessage;
import app.hima.net.SetUserMessageRead;

public class UserMessageAdapter extends MessageAdapter {
	protected Integer coid;

	
	public UserMessageAdapter(Context context) {
		super(context);
	}
	public UserMessageAdapter(Context context, Integer coid) {
		this(context);
		this.coid = coid;
	}
	
	@Override
	protected void load() throws ExecutionException, InterruptedException {
		Toast.makeText(getContext(), "メッセージを読み込み中", Toast.LENGTH_SHORT).show();
		new GetUserMessage(this).execute(coid);
	}
	
	@Override
	protected void setRead(int id) {
		if(coid !=null)
			new SetUserMessageRead().execute(id);
	}
}
