package kimiko.coreen.app.data.base;

import kimiko.coreen.app.data.hanja.Hanja;

import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

public class HanjaDAO extends DAOBase {
	public static final String HANJA_KEY = "_id";
	public static final String HANJA_HANGEUL = "hangeul";
	public static final String HANJA_HANJA = "hanja";

	public static final String HANJA_TABLE_NAME = "hanjas";
	public static final String HANJA_TABLE_CREATE =
			"CREATE TABLE IF NOT EXISTS " + HANJA_TABLE_NAME + " (" +
					HANJA_KEY + " INTEGER PRIMARY KEY AUTOINCREMENT, " +
					HANJA_HANGEUL + " TEXT, " +
					HANJA_HANJA + " TEXT);";
	public static final String HANJA_TABLE_DROP = "DROP TABLE IF EXISTS " + HANJA_TABLE_NAME + ";";
	
	public HanjaDAO(Context pContext) {
		super(pContext);
		Log.v(this.getClass().getSimpleName(), "Instanciation.");
	}
	
	public static void creer(SQLiteDatabase db) {
		db.execSQL(HANJA_TABLE_CREATE);
	}
	
	public static void supprimer(SQLiteDatabase db) {
		db.execSQL(HANJA_TABLE_DROP);
	}
	
	
	public void ajouter(Hanja hanja) {
		ajouter(hanja, mDb);
	}
	public static void ajouter(Hanja hanja, SQLiteDatabase db) {
		final String requete = "INSERT INTO " +HANJA_TABLE_NAME+ " ("+HANJA_HANGEUL+", "+HANJA_HANJA+") " +
				"VALUES ("+ DatabaseUtils.sqlEscapeString(hanja.getHangeul()) +", "+ DatabaseUtils.sqlEscapeString(hanja.getHanja())+")";
		Log.v(DAOBase.class.getSimpleName(), "Ajout du hanja : " + hanja + " dans : " + db);
		db.execSQL(requete);
	}
	
	public void supprimer(long id) {
		mDb.delete(HANJA_TABLE_NAME, HANJA_KEY + " = ?", new String[] {String.valueOf(id)});
	}

	public Cursor chercher(String entree) {
		entree = entree + "%";
		return mDb.rawQuery("select " + HANJA_KEY + ", " + HANJA_HANGEUL + ", " + HANJA_HANJA + " from " + HANJA_TABLE_NAME + " " +
				"where "+HANJA_HANGEUL+" like "+ DatabaseUtils.sqlEscapeString(entree) + " " +
						"or "+HANJA_HANJA+" like "+ DatabaseUtils.sqlEscapeString(entree) + "", new String[]{});
	}

	public Hanja random() {
		return null;
	}
}
