package kimiko.coreen.app.data.ui;

import kimiko.coreen.app.R;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.widget.CursorAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class MotAdapter extends CursorAdapter {

	public MotAdapter(Context context, Cursor cursor) {
		super(context, cursor, true);
	}

	public class ViewHolder {
		public TextView wordHangeul, wordHanja, wordRom, wordTrad;
	}

	@Override
	public void bindView(View view, Context context, Cursor cursor) {
		ViewHolder holder = new ViewHolder();
		holder.wordHangeul = (TextView)view.findViewById(R.id.wordHangeul);
		holder.wordTrad = (TextView)view.findViewById(R.id.wordTrad);
		holder.wordHanja = (TextView)view.findViewById(R.id.wordHanja);
		holder.wordRom = (TextView)view.findViewById(R.id.wordRom);
		view.setTag(holder);

		holder.wordHangeul.setText(cursor.getString(1));
		holder.wordTrad.setText(cursor.getString(2));
		holder.wordHanja.setText(cursor.getString(3));
		holder.wordRom.setText(cursor.getString(4));
		
		Bundle bundle = new Bundle();
		bundle.putString("hang", cursor.getString(1));
		bundle.putString("rom", cursor.getString(3));
		bundle.putString("hanj", cursor.getString(2));
		bundle.putString("trad", cursor.getString(4));
		view.setOnLongClickListener(new CopierListener(context, cursor.getString(1)));
		view.setOnClickListener(new DetailListener(context, bundle));
	}


	@Override
	public View newView(Context context, final Cursor cursor, ViewGroup viewGroup) {
		ViewHolder holder = new ViewHolder();
		LayoutInflater inflater = LayoutInflater.from(context);
		View view = inflater.inflate(R.layout.mot, null);
		holder.wordHangeul = (TextView)view.findViewById(R.id.wordHangeul);
		holder.wordTrad = (TextView)view.findViewById(R.id.wordTrad);
		holder.wordHanja = (TextView)view.findViewById(R.id.wordHanja);
		holder.wordRom = (TextView)view.findViewById(R.id.wordRom);
		view.setTag(holder);

		holder.wordHangeul.setText(cursor.getString(1));
		holder.wordTrad.setText(cursor.getString(2));
		holder.wordHanja.setText(cursor.getString(3));
		holder.wordRom.setText(cursor.getString(4));
		
		Bundle bundle = new Bundle();
		bundle.putString("hang", cursor.getString(1));
		bundle.putString("rom", cursor.getString(3));
		bundle.putString("hanj", cursor.getString(2));
		bundle.putString("trad", cursor.getString(4));
		view.setOnLongClickListener(new CopierListener(context, cursor.getString(1)));
		view.setOnClickListener(new DetailListener(context, bundle));
		return view;
	}
}
