package kimiko.coreen.app.view.Fragment;

import kimiko.coreen.app.R;
import kimiko.coreen.app.data.base.HanjaDAO;
import kimiko.coreen.app.data.ui.HanjaAdapter;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ListView;

public class HanjasFragment extends SearchFragment {
	protected Cursor hanjas;
	private HanjaDAO hanjaDAO;
	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		View view = super.onCreateView(inflater, container, savedInstanceState);
		
		this.listView = (ListView) view.findViewById(R.id.mots);

		
		this.hanjaDAO = new HanjaDAO(getActivity());
		hanjaDAO.open();
		
		return view;
	}
	
	@Override public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        this.searchView.setSuggestionsAdapter(null);
    }

	@Override
	public void chercher(String entree) {
		this.hanjas = hanjaDAO.chercher(entree);
		Log.v(this.getClass().getSimpleName(), "nombre de resultat : " + this.hanjas.getCount());
		
		this.adapter = new HanjaAdapter(getActivity(), this.hanjas);
		this.listView.setAdapter(adapter);
		
		this.searchView.setQuery("", false);
		
		InputMethodManager imm = (InputMethodManager) getActivity().getSystemService(FragmentActivity.INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(searchView.getWindowToken(), 0);
	}
	
	@Override
	public void onDestroy() {
		hanjaDAO.close();
		super.onDestroy();
	}
}
