package android.langue.furansugo;

import java.util.List;

import android.content.Context;
import android.langue.furansugo.dic.Mot;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

public class MotAdapteur extends BaseAdapter {
	private List<Mot> mots;
	LayoutInflater inflater;
	

	public MotAdapteur(Context context, List<Mot> list) {
		super();
		this.mots = list;
		inflater = LayoutInflater.from(context);
	}

	@Override
	public int getCount() {
		return mots.size();
	}

	@Override
	public Object getItem(int position) {
		return mots.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}
	
	private class ViewHolder {
		TextView jap;
		TextView trad;
	}
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		ViewHolder holder;
		if(convertView == null) {
			holder = new ViewHolder();
			convertView = inflater.inflate(R.layout.mot, null);
			holder.jap = (TextView) convertView.findViewById(R.id.textView1);
			holder.trad = (TextView) convertView.findViewById(R.id.textView2);
			convertView.setTag(holder);
		}
		else {
			holder = (ViewHolder) convertView.getTag();
		}
		holder.jap.setText(mots.get(position).getJap());
		holder.trad.setText(mots.get(position).getTrad());
		return convertView;
	}

}
