package android.langue.furansugo;

import android.langue.furansugo.dic.Dictionnaire;
import android.langue.furansugo.dic.Mot;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

public class MotHasardActivity extends FuransugoActivity {
	private TextView jap, yomi, trad;
	private Dictionnaire dic;
	
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.mothasard);
        
        dic = new Dictionnaire(getResources().openRawResource(R.raw.japonais));
        
        jap = (TextView) findViewById(R.id.mot);
        yomi = (TextView) findViewById(R.id.yomiV);
        trad = (TextView) findViewById(R.id.imiV);
        
        updateMot();
    }
	
	public void updateMot(View view) {
		updateMot();
	}
	private void updateMot() {
		Mot mot = dic.hasard();
		if(mot == null) return;
		jap.setText(mot.getJap());
		yomi.setText(mot.getKana());
		trad.setText(mot.getTrad());
	}
}
