package android.langue.furansugo;

import android.media.MediaPlayer;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;

public class PronActivity extends FuransugoActivity {
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.pron);
        
        ListView list = (ListView) findViewById(R.id.listView1);
        final String[] sonsNom = getResources().getStringArray(R.array.sonsNom);
        final String[] sonsJa = getResources().getStringArray(R.array.sonsJa);
        final String[] sonsFr = getResources().getStringArray(R.array.sonsFr);
        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1, sonsFr);
        list.setAdapter(adapter);

        list.setTextFilterEnabled(true);

        list.setOnItemClickListener(new OnItemClickListener() {
          public void onItemClick(AdapterView<?> parent, View view,
              int position, long id) {
            Toast.makeText(getApplicationContext(), sonsJa[position], Toast.LENGTH_SHORT).show();
            MediaPlayer mediaPlayer = MediaPlayer.create(getBaseContext(), getResources().getIdentifier(sonsNom[position], "raw", "android.langue.furansugo"));
            mediaPlayer.start();
          }
        });
    }

}
