package android.langue.furansugo.dic;

import java.util.ArrayList;
import java.util.List;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MotsHandler extends DefaultHandler {
	private List<Mot> dictionnaire;
	private Mot mot;
	private StringBuffer buffer;
	
	public MotsHandler() {
		super();
	}
	
	public void startElement(String uri, String locaName, String qName, Attributes attributes) throws SAXException {
		if(qName.equals("mots")) {
			dictionnaire = new ArrayList<Mot>();
		}else if (qName.equals("mot")) {
			this.mot = new Mot();
		}else {
			buffer = new StringBuffer();
		}
	}
	public void endElement(String uri, String locaName, String qName) throws SAXException {
		if(qName.equals("mots")) {
		}else if (qName.equals("mot")) {
			dictionnaire.add(mot);
		}else if(qName.equals("jap")) {
			if(buffer != null) mot.setJap(buffer.toString());
			buffer = null;
		}else if(qName.equals("kana")) {
			if(buffer != null) mot.setKana(buffer.toString());
			buffer = null;
		}else if(qName.equals("type")) {
			if(buffer != null) mot.setType(buffer.toString());
			buffer = null;
		}else if(qName.equals("trad")) {
			if(buffer != null) mot.setTrad(buffer.toString());
			buffer = null;
		}
	}
	
	public void characters(char[] ch, int start, int length) throws SAXException {
		String lecture = new String(ch, start, length);
		if(buffer != null) buffer.append(lecture);
	}
	public void startDocument() throws SAXException {}
	public void endDocument() throws SAXException {
	}

	public List<Mot> getDictionnaire() {
		return dictionnaire;
	}

}
