package app.hima.activity.fragment;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.Spinner;
import android.widget.Switch;
import app.hima.R;
import app.hima.activity.tools.ImageSelect;
import app.hima.activity.tools.SetProfil;
import app.hima.data.Profil;
import app.hima.net.GetProfile;
import app.hima.net.SetImageSmall;
import app.hima.net.UpdateProfile;
import app.hima.tool.ImageUploadService;
import app.hima.tool.Preferences;

public class ProfilFragment extends Fragment implements SetProfil {

	private Button profilSend;
	private EditText name, age, profil;
	private Switch sex;
	private Spinner place;
	private ImageButton image0, image1, image2, image3, image4, image5;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		View rootView = inflater.inflate(R.layout.fragment_profil_edit,
				container, false);

		this.name = (EditText) rootView.findViewById(R.id.profilEditName);
		this.age = (EditText) rootView.findViewById(R.id.profilEditAge);
		this.profil = (EditText) rootView.findViewById(R.id.profilEditProfil);
		this.sex = (Switch) rootView.findViewById(R.id.profilEditSex);
		this.place = (Spinner) rootView.findViewById(R.id.profilEditPlace);

		this.image0 = (ImageButton) rootView.findViewById(R.id.profilImage0);
		this.image1 = (ImageButton) rootView.findViewById(R.id.profilImage1);
		this.image2 = (ImageButton) rootView.findViewById(R.id.profilImage2);
		this.image3 = (ImageButton) rootView.findViewById(R.id.profilImage3);
		this.image4 = (ImageButton) rootView.findViewById(R.id.profilImage4);
		this.image5 = (ImageButton) rootView.findViewById(R.id.profilImage5);
		
		this.image0.setOnClickListener(new ImageSelect(this, 0));
		this.image1.setOnClickListener(new ImageSelect(this, 1));
		this.image2.setOnClickListener(new ImageSelect(this, 2));
		this.image3.setOnClickListener(new ImageSelect(this, 3));
		this.image4.setOnClickListener(new ImageSelect(this, 4));
		this.image5.setOnClickListener(new ImageSelect(this, 5));
		
		new SetImageSmall(this.image0).execute(Preferences.id+"-0.jpg");
		new SetImageSmall(this.image1).execute(Preferences.id+"-1.jpg");
		new SetImageSmall(this.image2).execute(Preferences.id+"-2.jpg");
		new SetImageSmall(this.image3).execute(Preferences.id+"-3.jpg");
		new SetImageSmall(this.image4).execute(Preferences.id+"-4.jpg");
		new SetImageSmall(this.image5).execute(Preferences.id+"-5.jpg");
		
		

		this.profilSend = (Button) rootView.findViewById(R.id.profilSendButton);

		this.profilSend.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				Profil pro = new Profil(Preferences.id, name.getText()
						.toString(), (sex.isChecked() ? "1" : "0"), age
						.getText().toString(), place.getSelectedItem()
						.toString(), profil.getText().toString());
				new UpdateProfile().execute(pro);
				
			}
		});

		new GetProfile(this).execute(Preferences.id);

		return rootView;
	}
	
	@Override
	public void setProfil(Profil profil) {
		if (profil != null) {
			this.name.setText(profil.getName());
			this.age.setText(profil.getAge());
			this.sex.setChecked(profil.getSex().equals("1"));
			Resources res = getResources();
			TypedArray icons = res.obtainTypedArray(R.array.Prefecture);

			String place = profil.getPlace();
			for (int i = 0; i < icons.length(); i++) {
				if (icons.getString(i).equals(place)) {
					this.place.setSelection(i);
					break;
				}
			}
			icons.recycle();
			this.profil.setText(profil.getProfile());
		}
	}

	@Override
	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		if(resultCode == Activity.RESULT_CANCELED)
			return;
		Uri selectedImageUri = data.getData();
		Intent i = new Intent(getActivity(), ImageUploadService.class);
		i.setData(selectedImageUri);
		i.putExtra("no", requestCode);
		getActivity().startService(i);
		switch (requestCode) {
		case 0:
			this.image0.setImageURI(selectedImageUri);
			break;
		case 1:
			this.image1.setImageURI(selectedImageUri);
			break;
		case 2:
			this.image2.setImageURI(selectedImageUri);
			break;
		case 3:
			this.image3.setImageURI(selectedImageUri);
			break;
		case 4:
			this.image4.setImageURI(selectedImageUri);
			break;
		case 5:
			this.image5.setImageURI(selectedImageUri);
			break;
		}
	}
}
