package app.hima.net;

import org.json.JSONArray;
import org.json.JSONException;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.TextView;
import app.hima.data.Profil;
import app.hima.tool.Buffer;

public class GetName extends AsyncTask<Integer, Integer, Profil> {

	private TextView profil;

	public GetName(TextView profilFragment) {
		this.profil = profilFragment;
	}

	@Override
	protected Profil doInBackground(Integer... params) {
		int id = params[0];
		final String URL = ServerRequest.SERVER + "getUser.pl?id="+ id;
        return Buffer.getProfil(id, URL);
	}
	
	@Override
	protected void onPostExecute(Profil profil) {
		if(profil !=null)
			this.profil.setText(profil.getName());
    }
	
	public static Profil getProfil(int id, String URL) {
		try {
			JSONArray pages = new JSONArray(ServerRequest.send(URL));
			Log.v(GetName.class.getClass().getSimpleName(), pages.length() + "");
			Profil profile = new Profil(id, pages.getString(0), pages.getString(1), pages.getString(2), pages.getString(3), pages.getString(4));
			return profile;
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return null;
	}

}
