package app.hima.net;

import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.widget.ImageView;
import app.hima.tool.Buffer;

public class SetImageSmall extends AsyncTask<String, Integer, Drawable> {

	private ImageView imageButton;

	public SetImageSmall(ImageView imageButton) {
		this.imageButton = imageButton;
	}

	@Override
	protected Drawable doInBackground(String... params) {
		String imageName = params[0];
		String URL = ServerRequest.SERVER + "getResizedImage.pl?nom="+ imageName + "&largeur=250";
		return Buffer.getImage(URL);
	}
	
	@Override
	protected void onPostExecute(Drawable image) {
		if(image == null)
			return;
		this.imageButton.setImageDrawable(image);
		this.imageButton.invalidate();
    }

}
