package app.hima.tool;

import java.util.HashMap;
import java.util.Map;

import android.graphics.drawable.Drawable;
import app.hima.data.Profil;
import app.hima.net.GetProfile;
import app.hima.net.ServerRequest;

public class Buffer {
	private static Map<String, Drawable> images = new HashMap<String, Drawable>();
	private static Map<String, Profil> profils = new HashMap<String, Profil>();
	
	public static Drawable getImage(String name) {
		if(!images.containsKey(name))
		{
			Drawable image = ServerRequest.LoadImageFromWebOperations(name);
			//if(image != null)
				images.put(name, image);
		}
		return images.get(name);
	}
	
	public static Profil getProfil(int id, String URL) {
		if(!profils.containsKey(URL))
		{
			Profil profil = GetProfile.getProfil(id, URL);
			if(profil != null)
				profils.put(URL, profil);
		}
		return profils.get(URL);
	}

	public static void setProfil(String URL, Profil profil) {
		profils.put(URL, profil);
	}
}
