package kimiko.coreen.app.data.base;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

public abstract class DAOBase {
	  protected final static int VERSION = 10;
	  protected final static String NOM = "database.db";
	     
	  protected SQLiteDatabase mDb = null;
	  protected DatabaseHandler mHandler = null;
	     
	  public DAOBase(Context pContext) {
	    this.mHandler = new DatabaseHandler(pContext, NOM, null, VERSION);
	  }
	     
	  public SQLiteDatabase open() {
	    mDb = mHandler.getWritableDatabase();
	    Log.v(this.getClass().getSimpleName(), "MDB" + mDb);
	    return mDb;
	  }
	     
	  public void close() {
	    mDb.close();
	  }
	     
	  public SQLiteDatabase getDb() {
	    return mDb;
	  }
	}