package kimiko.coreen.app.data.mots;

import kimiko.coreen.app.data.Data;

public class Mot extends Data {
	private static int ID = 0;
	private final String hangeul;
	private final String hanja;
	private final String romanization;
	private final String traduction;
	private final String type;
	
	
	public Mot(String hangeul, String hanja, String romanization, String traduction, String type) {
		super(ID++);
		this.hangeul = hangeul;
		this.hanja = hanja;
		this.romanization = romanization;
		this.traduction = traduction;
		this.type = type;
	}


	public String getHangeul() {
		return hangeul;
	}


	public String getHanja() {
		return hanja;
	}


	public String getRomanization() {
		return romanization;
	}


	public String getTraduction() {
		return traduction;
	}


	public String getType() {
		return type;
	}


	@Override
	public String toString() {
		return "Mot [hangeul=" + hangeul + ", hanja=" + hanja
				+ ", romanization=" + romanization + ", traduction="
				+ traduction + ", type=" + type + "]";
	}
	
}
