package kimiko.coreen.app.view.Fragment;

import java.util.Locale;

import kimiko.coreen.app.R;
import kimiko.coreen.app.data.base.MotDAO;
import kimiko.coreen.app.data.ui.CopierListener;
import kimiko.coreen.app.data.ui.MotAdapter;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.speech.tts.TextToSpeech;
import android.speech.tts.TextToSpeech.OnInitListener;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.TextView;

public class ExempleFragment extends DetailFragment implements OnInitListener {
	private String tradText, hangText;
	private TextView hang, roma, trad;
	private ImageButton lecture;
	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		View view = inflater.inflate(R.layout.fragment_exemple, container, false);
		setHasOptionsMenu(true);
		this.tts = new TextToSpeech(this.getActivity(), this);
		this.tts.setSpeechRate(0.8f);
		
		Bundle b = this.getActivity().getIntent().getExtras();
		if(b==null)
			b = getArguments();
		
		this.tradText = b.getString("trad");
		this.hangText = b.getString("hang");
		
		this.hang = ((TextView)view.findViewById(R.id.hang));
		this.roma = ((TextView)view.findViewById(R.id.roma));
		this.trad = ((TextView)view.findViewById(R.id.trad));
		
		this.lecture = ((ImageButton)view.findViewById(R.id.lecture));
		this.lecture.setAlpha(0.5f);
		ListView listView = (ListView) view.findViewById(R.id.mots);
		
		this.hang.setText(b.getString("hang"));
		this.roma.setText(b.getString("rom"));
		this.trad.setText(b.getString("trad"));
		
		this.hang.setOnLongClickListener(new CopierListener(this.getActivity(), b.getString("hang")));
		this.roma.setOnLongClickListener(new CopierListener(this.getActivity(), b.getString("rom")));
		this.trad.setOnLongClickListener(new CopierListener(this.getActivity(), b.getString("trad")));
		
		MotDAO motDAO = new MotDAO(this.getActivity());
		motDAO.open();
		Cursor mots = motDAO.chercherHangeul(b.getString("hang").split(" "));
		MotAdapter adapter = new MotAdapter(this.getActivity(), mots);
		listView.setAdapter(adapter);
		motDAO.close();
		
		return view;
	}

	@Override
	public void onInit(int status) {
		if (status == TextToSpeech.SUCCESS) {
			int result = TextToSpeech.LANG_MISSING_DATA;
			if(Locale.getDefault().equals(Locale.KOREA)||Locale.getDefault().equals(Locale.KOREAN))
			{
				Locale loc = new Locale("fre", "FRA");
				result = tts.setLanguage(loc);
			}
			else
			{
				result = tts.setLanguage(Locale.KOREA);
			}
			if (result == TextToSpeech.LANG_MISSING_DATA || result == TextToSpeech.LANG_NOT_SUPPORTED) {
				Log.e("TTS", "This Language is not supported");
				Intent installIntent = new Intent();
				installIntent.setAction(TextToSpeech.Engine.ACTION_INSTALL_TTS_DATA);
				startActivity(installIntent);
			}
			this.lecture.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					
					if(Locale.getDefault().equals(Locale.KOREA)||Locale.getDefault().equals(Locale.KOREAN))
						tts.speak(tradText, TextToSpeech.QUEUE_FLUSH, null);
					else
						tts.speak(hangText, TextToSpeech.QUEUE_FLUSH, null);
				}
			});
			this.lecture.setAlpha(1f);
		} else {
			Log.e("TTS", "Initilization Failed!");
		}
	}
	
	@Override
	public void onDestroy() {
		this.tts.shutdown();
		super.onDestroy();
	}

}
