package kimiko.coreen.app.view.Fragment;

import kimiko.coreen.app.R;
import kimiko.coreen.app.data.base.MotDAO;
import kimiko.coreen.app.data.ui.MotAdapter;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ListView;

public class MotsFragment extends SearchFragment{
	protected Cursor mots;
	protected MotDAO motDAO;
	
	
	@Override
	public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		View view = super.onCreateView(inflater, container, savedInstanceState);
		
		this.listView = (ListView) view.findViewById(R.id.mots);

		
		this.motDAO = new MotDAO(getActivity());

		Intent intent = getActivity().getIntent();
		if (Intent.ACTION_VIEW.equals(intent.getAction())) {
		    Log.v("DICVIW", intent.getDataString());
		    chercher(intent.getDataString());
		}
		
		return view;
	}
	
	@Override
	public void chercher(String entree) {
		motDAO.open();
		this.mots = motDAO.chercher(entree);
		Log.v(this.getClass().getSimpleName(), "nombre de resultat : " + this.mots.getCount());
		
		this.adapter = new MotAdapter(getActivity(), this.mots);
		this.listView.setAdapter(adapter);
		
		if(this.searchView!=null)
		{
			this.searchView.setQuery("", false);
			
			InputMethodManager imm = (InputMethodManager) getActivity().getSystemService(FragmentActivity.INPUT_METHOD_SERVICE);
	        imm.hideSoftInputFromWindow(searchView.getWindowToken(), 0);
		}
		motDAO.close();
	}
}
