package kimiko.coreen.app.data.base;

import kimiko.coreen.app.data.exemples.Exemple;

import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

public class ExempleDAO extends DAOBase {
	public static final String EXEMPLE_KEY = "_id";
	public static final String EXEMPLE_HANGEUL = "hangeul";
	public static final String EXEMPLE_ROMANIZATION = "romanization";
	public static final String EXEMPLE_TRADUCTION = "traduction";

	public static final String EXEMPLE_TABLE_NAME = "exemples";
	public static final String EXEMPLE_TABLE_CREATE =
			"CREATE TABLE IF NOT EXISTS " + EXEMPLE_TABLE_NAME + " (" +
					EXEMPLE_KEY + " INTEGER PRIMARY KEY AUTOINCREMENT, " +
					EXEMPLE_HANGEUL + " TEXT, " +
					EXEMPLE_ROMANIZATION + " TEXT, " +
					EXEMPLE_TRADUCTION + " TEXT);";
	public static final String EXEMPLE_TABLE_DROP = "DROP TABLE IF EXISTS " + EXEMPLE_TABLE_NAME + ";";
	
	public ExempleDAO(Context pContext) {
		super(pContext);
		Log.v(this.getClass().getSimpleName(), "Instanciation.");
	}
	
	public static void creer(SQLiteDatabase db) {
		db.execSQL(EXEMPLE_TABLE_CREATE);
	}
	
	public static void supprimer(SQLiteDatabase db) {
		db.execSQL(EXEMPLE_TABLE_DROP);
	}
	public void ajouter(Exemple ex) {
		ajouter(ex, mDb);
	}
	public static void ajouter(Exemple ex, SQLiteDatabase db) {
		final String requete = "INSERT INTO " +EXEMPLE_TABLE_NAME+ " ("+EXEMPLE_HANGEUL+", "+EXEMPLE_ROMANIZATION+", "+EXEMPLE_TRADUCTION+") " +
				"VALUES ("+ DatabaseUtils.sqlEscapeString(ex.getHangeul()) +", "+ DatabaseUtils.sqlEscapeString(ex.getRomanization()) +", "+DatabaseUtils.sqlEscapeString(ex.getTraduction())+")";
		//Log.v(DAOBase.class.getSimpleName(), "Ajout de l'exemple : " + ex + " dans : " + db);
		db.execSQL(requete);
	}
	
	public void supprimer(long id) {
		mDb.delete(EXEMPLE_TABLE_NAME, EXEMPLE_KEY + " = ?", new String[] {String.valueOf(id)});
	}

	public Cursor chercher(String entree) {
		entree = "%" +  entree + "%";
		return mDb.rawQuery("select " + EXEMPLE_KEY + ", " + EXEMPLE_HANGEUL + ", " + EXEMPLE_ROMANIZATION + ", " + EXEMPLE_TRADUCTION+ " from " + EXEMPLE_TABLE_NAME + " where "
	+EXEMPLE_HANGEUL+" like "+ DatabaseUtils.sqlEscapeString(entree) + " " +
			"or "+EXEMPLE_ROMANIZATION+" like "+ DatabaseUtils.sqlEscapeString(entree) + " " +
					"or "+EXEMPLE_TRADUCTION+" like "+ DatabaseUtils.sqlEscapeString(entree), new String[]{});
	}

	public Exemple random() {
		return null;
	}
}
