package kimiko.coreen.app.data.tools;


import java.util.List;

import kimiko.coreen.app.data.hanja.Hanja;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HanjaLoader extends DefaultHandler {
	private List<Hanja> hanjas;
	private String hanja, hangeul;
	private StringBuffer buffer;

	public HanjaLoader(List<Hanja> hanjas) {
		this.hanjas = hanjas;
	}


	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		if (qName.equals("hanjas")) {
		} else if (qName.equals("hanja")) {
			hangeul = hanja = "";
		} else {
			buffer = new StringBuffer();
		}
	}

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if (qName.equals("hanjas")) {
		} else if (qName.equals("hanja")) {
			synchronized(this.hanjas) {
			    this.hanjas.add(new Hanja(hanja, hangeul));
			}
			//Log.v(this.getClass().getSimpleName(), "taille : " + hanjas.size());
		} else if (qName.equals("hang")) {
			this.hangeul = buffer.toString();
			buffer=null;
		} else if (qName.equals("car")) {
			this.hanja = buffer.toString();
			buffer=null;
		}
	}

	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		String lecture = new String(ch, start, length);
		if (buffer != null)
			buffer.append(lecture);
	}
}
