package kimiko.coreen.app.data.tools.provider;

import kimiko.coreen.app.data.base.MotDAO;
import android.app.SearchManager;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.net.Uri;
import android.provider.BaseColumns;
import android.util.Log;

public class SuggestionProviderMots extends ContentProvider {
	private String[] mProjection = {BaseColumns._ID, SearchManager.SUGGEST_COLUMN_TEXT_1, SearchManager.SUGGEST_COLUMN_INTENT_ACTION, SearchManager.SUGGEST_COLUMN_INTENT_DATA};
	private MotDAO motDAO;

	@Override
	public String getType(Uri arg0) {
		return null;
	}

	@Override
	public Cursor query(Uri uri, String[] projection, String arg2, String[] arg3, String arg4) {
		try {
			motDAO.open();
			String query = uri.getLastPathSegment();
			Cursor resulta = motDAO.chercherSimple(query);
			MatrixCursor cursor = new MatrixCursor(mProjection);
			Log.v(this.getClass().getSimpleName(), uri.toString());

			while(resulta.moveToNext()) {
				Object[] wordRow = {resulta.getString(0), resulta.getString(1) + " " + resulta.getString(2), Intent.ACTION_VIEW, resulta.getString(1)};
				cursor.addRow(wordRow);
			}
			motDAO.close();
			return cursor;
		} catch (SQLiteDatabaseLockedException ex) {
			ex.printStackTrace();
		}
		return null;
	}

	@Override
	public int delete(Uri uri, String selection, String[] selectionArgs) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public Uri insert(Uri uri, ContentValues values) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean onCreate() {
		motDAO = new MotDAO(getContext());
		return false;
	}

	@Override
	public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
		// TODO Auto-generated method stub
		return 0;
	}

}
