package kimiko.coreen.app.view.Fragment;

import kimiko.coreen.app.R;
import kimiko.coreen.app.data.base.ExempleDAO;
import kimiko.coreen.app.data.ui.ExampleAdapter;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ListView;

public class ExemplesFragment extends SearchFragment {
	protected Cursor exemples;
	private ExempleDAO exempleDAO;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		View view = super.onCreateView(inflater, container, savedInstanceState);

		this.listView = (ListView) view.findViewById(R.id.mots);

		this.exempleDAO = new ExempleDAO(getActivity());

		return view;
	}

	@Override public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
		super.onCreateOptionsMenu(menu, inflater);
		this.searchView.setSuggestionsAdapter(null);
	}

	@Override
	public void chercher(String entree) {
		try {
			exempleDAO.open();
			this.exemples = exempleDAO.chercher(entree);

			Log.v(this.getClass().getSimpleName(), "nombre de resultat : " + this.exemples.getCount());

			this.adapter = new ExampleAdapter(getActivity(), this.exemples);
			this.listView.setAdapter(adapter);

			this.searchView.setQuery("", false);

			InputMethodManager imm = (InputMethodManager) getActivity().getSystemService(FragmentActivity.INPUT_METHOD_SERVICE);
			imm.hideSoftInputFromWindow(searchView.getWindowToken(), 0);
			exempleDAO.close();
		} catch (SQLiteDatabaseLockedException ex) {
			ex.printStackTrace();
		}
	}
}
