package kimiko.coreen.app.view.Fragment;

import kimiko.coreen.app.R;
import android.app.SearchManager;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SearchView;
import android.widget.SearchView.OnQueryTextListener;

public abstract class SearchFragment extends Fragment {
	protected ListView listView;
	protected ListAdapter adapter;
	protected SearchView searchView;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		View view = inflater.inflate(R.layout.search_fragment, container, false);
		setHasOptionsMenu(true);
		
		this.listView = (ListView) view.findViewById(R.id.mots);
		return view;
	}

	@Override
	public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
		super.onCreateOptionsMenu(menu, inflater);
		inflater.inflate(R.menu.search_fragment, menu);
		
		this.searchView = (SearchView) menu.findItem(R.id.menu_rechercher).getActionView();
	    SearchManager searchManager = (SearchManager) getActivity().getSystemService(Context.SEARCH_SERVICE);
	    searchView.setSearchableInfo(searchManager.getSearchableInfo(getActivity().getComponentName()));
	    
	    searchView.setOnSuggestionListener(new SearchView.OnSuggestionListener() {
	        @Override
	        public boolean onSuggestionSelect(int position) {
	            return true;
	        }

	        @Override
	        public boolean onSuggestionClick(int position) {
	            CursorAdapter selectedView = searchView.getSuggestionsAdapter();
	            Cursor cursor = (Cursor) selectedView.getItem(position);
	            int index = cursor.getColumnIndexOrThrow(SearchManager.SUGGEST_COLUMN_INTENT_DATA);
	            searchView.setQuery(cursor.getString(index), true);
	            return true;
	        }
	    });

	    searchView.setOnQueryTextListener(new OnQueryTextListener() {
			@Override
			public boolean onQueryTextSubmit(String query) {
				Log.v(this.getClass().getSimpleName(), "Recherche de : " + query);
				chercher(query);
				return true;
			}
			@Override
			public boolean onQueryTextChange(String newText) {
				Log.v(this.getClass().getSimpleName(), "Entree de : " + newText);
				return false;
			}
		});
	}
	
	public abstract void chercher(String entree);

}
