package kimiko.coreen.app.data.tools;

import java.util.List;

import kimiko.coreen.app.data.exemples.Exemple;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import android.util.Log;

public class ExempleLoader extends DefaultHandler {
	private List<Exemple> exemples;
	private String hangeul, rom, meaning;
	private StringBuffer buffer;

	public ExempleLoader(List<Exemple> exemples) {
		this.exemples = exemples;
	}


	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		if (qName.equals("phrases")) {
		} else if (qName.equals("phrase")) {
			hangeul = rom  = meaning = "";
		} else {
			buffer = new StringBuffer();
			if (qName.equals("hang")) {
			} else if (qName.equals("coreen")) {
			} else if (qName.equals("romanisation")) {
			} else if (qName.equals("francais")) {
			} 
		}
	}

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if (qName.equals("phrases")) {
		} else if (qName.equals("phrase")) {
			synchronized(this.exemples) {
			    this.exemples.add(new Exemple(hangeul, rom, meaning));
			}
			Log.v(this.getClass().getSimpleName(), "taille : " + exemples.size());
		} else if (qName.equals("coreen")) {
			this.hangeul = buffer.toString();
			buffer=null;
		} else if (qName.equals("romanisation")) {
			this.rom = buffer.toString();
			buffer=null;
		}
		else if (qName.equals("francais")) {
			this.meaning = buffer.toString();
			buffer=null;
		}
	}

	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		String lecture = new String(ch, start, length);
		if (buffer != null)
			buffer.append(lecture);
	}
}
