package kimiko.coreen.app.data.tools;

import java.util.List;

import kimiko.coreen.app.data.mots.Mot;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import android.util.Log;

public class MotLoader extends DefaultHandler {
	private List<Mot> mots;
	private String hangeul, hanja, rom, type, meaning;
	private StringBuffer buffer;

	public MotLoader(List<Mot> mots) {
		this.mots = mots;
	}


	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		if (qName.equals("mots")) {
		} else if (qName.equals("mot")) {
			hangeul = hanja = rom = type = meaning = "";
		} else {
			buffer = new StringBuffer();
			if (qName.equals("hang")) {
			} else if (qName.equals("hanj")) {
			} else if (qName.equals("rom")) {
			} else if (qName.equals("trad")) {
			} else if (qName.equals("type")) {
			} 
		}
	}

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if (qName.equals("mots")) {
		} else if (qName.equals("mot")) {
			synchronized(this.mots) {
				this.mots.add(new Mot(hangeul, hanja, rom, meaning, type));
			}
			Log.v(this.getClass().getSimpleName(), "taille : " + this.mots.size());
		} else if (qName.equals("hang")) {
			this.hangeul = buffer.toString();
			buffer=null;
		} else if (qName.equals("hang")) {
			this.hanja = buffer.toString();
			buffer=null;
		}
		else if (qName.equals("hanj")) {
			this.hanja = buffer.toString();
			buffer=null;
		}
		else if (qName.equals("rom")) {
			this.rom = buffer.toString();
			buffer=null;
		}
		else if (qName.equals("trad")) {
			this.meaning = buffer.toString();
			buffer=null;
		} else if (qName.equals("type")) {
			this.type = buffer.toString();
			buffer=null;
		}
	}

	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		String lecture = new String(ch, start, length);
		if (buffer != null)
			buffer.append(lecture);
	}
}
