package kimiko.coreen.app.data.ui;

import kimiko.coreen.app.R;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.widget.CursorAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class ExampleAdapter extends CursorAdapter {


	public ExampleAdapter(Context context, Cursor cursor) {
		super(context, cursor, true);
	}

	private class ViewHolder {
		TextView exampleHangeul, exampleRom, exampleTrad;
	}
	
	@Override
	public void bindView(View view, Context context, Cursor cursor) {
		ViewHolder holder = new ViewHolder();
		holder.exampleHangeul = (TextView)view.findViewById(R.id.exampleHangeul);
		holder.exampleRom = (TextView)view.findViewById(R.id.exampleRom);
		holder.exampleTrad = (TextView)view.findViewById(R.id.exampleTrad);

		holder.exampleHangeul.setText(cursor.getString(1));
		holder.exampleRom.setText(cursor.getString(2));
		holder.exampleTrad.setText(cursor.getString(3));
	}


	@Override
	public View newView(final Context context, final Cursor cursor, ViewGroup viewGroup) {
		ViewHolder holder = new ViewHolder();
		LayoutInflater inflater = LayoutInflater.from(context);
		View view = inflater.inflate(R.layout.exemple, null);
		holder.exampleHangeul = (TextView)view.findViewById(R.id.exampleHangeul);
		holder.exampleRom = (TextView)view.findViewById(R.id.exampleRom);
		holder.exampleTrad = (TextView)view.findViewById(R.id.exampleTrad);

		holder.exampleHangeul.setText(cursor.getString(1));
		holder.exampleRom.setText(cursor.getString(2));
		holder.exampleTrad.setText(cursor.getString(3));
		
		view.setOnLongClickListener(new CopierListener(context, cursor.getString(1)));
		return view;
	}
}
