package kimiko.coreen.app.data.ui;


import kimiko.coreen.app.R;
import android.content.Context;
import android.database.Cursor;
import android.support.v4.widget.CursorAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class HanjaAdapter extends CursorAdapter {

	public HanjaAdapter(Context context, Cursor cursor) {
		super(context, cursor, true);
	}
	
	private class ViewHolder {
		TextView hanjaHangeul, hanjaHanja;
	}
	
	@Override
	public void bindView(View view, Context context, Cursor cursor) {
		ViewHolder holder = new ViewHolder();
		holder.hanjaHangeul = (TextView)view.findViewById(R.id.hanjaHanja);
		holder.hanjaHanja = (TextView)view.findViewById(R.id.hanjaHangeul);

		holder.hanjaHangeul.setText(cursor.getString(1));
		holder.hanjaHanja.setText(cursor.getString(2));
	}


	@Override
	public View newView(final Context context, final Cursor cursor, ViewGroup viewGroup) {
		ViewHolder holder = new ViewHolder();
		LayoutInflater inflater = LayoutInflater.from(context);
		View view = inflater.inflate(R.layout.hanja, null);
		holder.hanjaHangeul = (TextView)view.findViewById(R.id.hanjaHanja);
		holder.hanjaHanja = (TextView)view.findViewById(R.id.hanjaHangeul);

		holder.hanjaHangeul.setText(cursor.getString(1));
		holder.hanjaHanja.setText(cursor.getString(2));
		
		view.setOnLongClickListener(new CopierListener(context, cursor.getString(2)));
		return view;
	}
}
