package kimiko.japonais.app;

import kimiko.japonais.app.data.MotDAO;
import kimiko.japonais.app.data.ui.MotAdapter;
import kimiko.japonais.app.R;
import android.os.Bundle;
import android.app.Activity;
import android.app.SearchManager;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.inputmethod.InputMethodManager;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SearchView;
import android.widget.SearchView.OnQueryTextListener;

public class MainActivity extends Activity {
	private ListView listView;
	private ListAdapter adapter;
	private SearchView searchView;
	private MotDAO motDAO;
	private Cursor mots;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		this.listView = (ListView) this.findViewById(R.id.listView1);
		
		this.motDAO = new MotDAO(this);
		motDAO.open();
		
		Intent intent = getIntent();
		if (Intent.ACTION_VIEW.equals(intent.getAction())) {
		    Log.v("DICVIW", intent.getDataString());
		    chercher(intent.getDataString());
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main, menu);
		
		this.searchView = (SearchView) menu.findItem(R.id.menu_rechercher).getActionView();
	    SearchManager searchManager = (SearchManager) getSystemService(Context.SEARCH_SERVICE);
	    searchView.setSearchableInfo(searchManager.getSearchableInfo(getComponentName()));

	    searchView.setOnQueryTextListener(new OnQueryTextListener() {
			@Override
			public boolean onQueryTextSubmit(String query) {
				Log.v(this.getClass().getSimpleName(), "Recherche de : " + query);
				chercher(query);
				return true;
			}
			@Override
			public boolean onQueryTextChange(String newText) {
				Log.v(this.getClass().getSimpleName(), "Entree de : " + newText);
				return false;
			}
		});
		
		return true;
	}
	
	public void chercher(String entree) {
		this.mots = motDAO.chercher(entree);
		Log.v(this.getClass().getSimpleName(), "nombre de resultat : " + this.mots.getCount());
		
		this.adapter = new MotAdapter(this, this.mots);
		this.listView.setAdapter(adapter);
		
		if(this.searchView !=null)
		{
			this.searchView.setQuery("", false);
			InputMethodManager imm = (InputMethodManager) getSystemService(FragmentActivity.INPUT_METHOD_SERVICE);
			imm.hideSoftInputFromWindow(searchView.getWindowToken(), 0);
		}
	}
	
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.menu_quiz:
			Intent myIntent = new Intent(this, QuizActivity.class);
			startActivity(myIntent);
			return true;
		case R.id.menu_info:
			Intent myIntentInfo = new Intent(this, InfoActivity.class);
			startActivity(myIntentInfo);
			return true;
		case R.id.menu_quitter:
			System.exit(0);
		}
		return false;
	}

}
