package kimiko.japonais.app.data.ui;

import kimiko.japonais.app.R;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.view.View;
import android.view.View.OnLongClickListener;
import android.widget.Toast;

public class CopierListener implements OnLongClickListener {
	private Context context;
	private String valeur;

	public CopierListener(Context context, String valeur) {
		this.context = context;
		this.valeur = valeur;
	}

	@Override
	public boolean onLongClick(View v) {
		ClipboardManager clipboard = (ClipboardManager)context.getSystemService(Context.CLIPBOARD_SERVICE); 
		ClipData clip = ClipData.newPlainText(valeur, valeur);
		clipboard.setPrimaryClip(clip);
		Toast.makeText(context, valeur + " "+ context.getResources().getString(R.string.copie_presse_papier), Toast.LENGTH_SHORT).show();
		return true;
	}
}