package kimiko.japonais.app.data;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public abstract class DAOBase {
	  protected final static int VERSION = 21;
	  
	     
	  protected SQLiteDatabase mDb = null;
	  protected SQLiteOpenHelper mHandler = null;
	     
	  public DAOBase(Context pContext) {
	    this.mHandler = new DatabaseHandlerMot(pContext, getNOM(), null, VERSION);
	  }
	     
	  public DAOBase() {
	}

	public SQLiteDatabase open() {
	    mDb = mHandler.getWritableDatabase();
	    //Log.v(this.getClass().getSimpleName(), "MDB" + mDb);
	    return mDb;
	  }
	     
	  public void close() {
	    mDb.close();
	  }
	     
	  public SQLiteDatabase getDb() {
	    return mDb;
	  }
	  
	  public abstract String getNOM();
	}