package kimiko.japonais.app.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import kimiko.japonais.app.data.tools.MotLoader;
import kimiko.japonais.app.R;

import android.app.AlertDialog;
import android.content.Context;
import android.content.res.Resources.NotFoundException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import android.widget.Toast;

public class DatabaseHandlerMot extends SQLiteOpenHelper {
	private Context context;

	public DatabaseHandlerMot(Context context, String name, CursorFactory factory,
			int version) {
		super(context, name, factory, version);
		this.context = context;
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		Log.v(this.getClass().getSimpleName(), "Creation de la base." + context);
		
		
		AlertDialog.Builder builder = new AlertDialog.Builder(context);
		builder.setMessage(R.string.chargement_debut);//.setTitle(R.string.chargement_debut);
		builder.setCancelable(false);
		
		AlertDialog dialog = builder.create();
		dialog.show();
		
//		Intent intent = new Intent(context, ChargementActivity.class);
//		intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//		context.startActivity(intent);
		
		
		
		MotDAO.creer(db);
		

		try {
			SAXParserFactory factory = SAXParserFactory.newInstance();
			SAXParser parser = factory.newSAXParser();
			List<Mot> mots = new ArrayList<Mot>();
			DefaultHandler handler = new MotLoader(mots);
			parser.parse(context.getResources().openRawResource(R.raw.mots),
					handler);

			for (Mot m : mots)
			{
				MotDAO.ajouter(m,db);
				Log.v(this.getClass().getSimpleName(), m.toString());
			}

		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (NotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		dialog.dismiss();

		Log.v(this.getClass().getSimpleName(), "Fin de la creation de la base.");
		Toast.makeText(context, context.getResources().getString(R.string.chargement_fin), Toast.LENGTH_SHORT).show();
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		MotDAO.supprimer(db);
		onCreate(db);
	}
}
