package kimiko.japonais.app.data;


import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

public class ExempleDAO extends DAOBase {
	protected final static String NOM = "databaseE.db";
	public static final String EXEMPLE_KEY = "_id";
	public static final String EXEMPLE_JAPONAIS = "japonais";
	public static final String EXEMPLE_ROMANIZATION = "romanization";
	public static final String EXEMPLE_TRADUCTION = "traduction";

	public static final String EXEMPLE_TABLE_NAME = "exemples";
	public static final String EXEMPLE_TABLE_CREATE =
			"CREATE TABLE IF NOT EXISTS " + EXEMPLE_TABLE_NAME + " (" +
					EXEMPLE_KEY + " INTEGER PRIMARY KEY AUTOINCREMENT, " +
					EXEMPLE_JAPONAIS + " TEXT, " +
					EXEMPLE_ROMANIZATION + " TEXT, " +
					EXEMPLE_TRADUCTION + " TEXT);";
	public static final String EXEMPLE_TABLE_DROP = "DROP TABLE IF EXISTS " + EXEMPLE_TABLE_NAME + ";";
	
	public ExempleDAO(Context pContext) {
		super();
		this.mHandler = new DatabaseHandlerExemple(pContext, getNOM(), null, VERSION);
		Log.v(this.getClass().getSimpleName(), "Instanciation.");
	}
	
	public static void creer(SQLiteDatabase db) {
		db.execSQL(EXEMPLE_TABLE_CREATE);
	}
	
	public static void supprimer(SQLiteDatabase db) {
		db.execSQL(EXEMPLE_TABLE_DROP);
	}
	public void ajouter(Exemple ex) {
		ajouter(ex, mDb);
	}
	public static void ajouter(Exemple ex, SQLiteDatabase db) {
		final String requete = "INSERT INTO " +EXEMPLE_TABLE_NAME+ " ("+EXEMPLE_JAPONAIS+", "+EXEMPLE_ROMANIZATION+", "+EXEMPLE_TRADUCTION+") " +
				"VALUES ("+ DatabaseUtils.sqlEscapeString(ex.getHangeul()) +", "+ DatabaseUtils.sqlEscapeString(ex.getRomanization()) +", "+DatabaseUtils.sqlEscapeString(ex.getTraduction())+")";
		//Log.v(DAOBase.class.getSimpleName(), "Ajout de l'exemple : " + ex + " dans : " + db);
		db.execSQL(requete);
	}
	
	public void supprimer(long id) {
		mDb.delete(EXEMPLE_TABLE_NAME, EXEMPLE_KEY + " = ?", new String[] {String.valueOf(id)});
	}

	public Cursor chercher(String entree) {
		entree = "%" +  entree + "%";
		return mDb.rawQuery("select " + EXEMPLE_KEY + ", " + EXEMPLE_JAPONAIS + ", " + EXEMPLE_ROMANIZATION + ", " + EXEMPLE_TRADUCTION+ " from " + EXEMPLE_TABLE_NAME + " where "
	+EXEMPLE_JAPONAIS+" like "+ DatabaseUtils.sqlEscapeString(entree) + " " +
			"or "+EXEMPLE_ROMANIZATION+" like "+ DatabaseUtils.sqlEscapeString(entree) + " " +
					"or "+EXEMPLE_TRADUCTION+" like "+ DatabaseUtils.sqlEscapeString(entree), new String[]{});
	}
	
	@Override
	public String getNOM() {
		return NOM;
	}

	public Exemple random() {
		Cursor cursor = this.mDb.query(EXEMPLE_TABLE_NAME +" Order BY RANDOM() LIMIT 1", new String[] { "*" }, null, null, null, null, null);
		cursor.moveToNext();
		return new Exemple(cursor.getString(1), cursor.getString(2), cursor.getString(3), cursor.getString(4));
	}
}
