package kimiko.japonais.app.data.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import kimiko.japonais.app.ChargementActivity;
import kimiko.japonais.app.R;
import kimiko.japonais.app.data.Exemple;
import kimiko.japonais.app.data.ExempleDAO;
import kimiko.japonais.app.data.Mot;
import kimiko.japonais.app.data.MotDAO;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import android.content.res.Resources.NotFoundException;

public class DataBaseCreation implements Runnable {
	private ChargementActivity activity;

	public DataBaseCreation(ChargementActivity activity) {
		super();
		this.activity = activity;
	}

	@Override
	public void run() {
		try {
			SAXParserFactory factory = SAXParserFactory.newInstance();
			SAXParser parser = factory.newSAXParser();
			List<Mot> mots = new ArrayList<Mot>();
			DefaultHandler handler = new MotLoader(mots);
			parser.parse(activity.getResources().openRawResource(R.raw.mots),
					handler);

			MotDAO motDAO = new MotDAO(activity);
			motDAO.open();
			for (Mot m : mots) {
				motDAO.ajouter(m);
				activity.incrementNb();
			}
			motDAO.close();

			List<Exemple> exemples = new ArrayList<Exemple>();
			DefaultHandler handler1 = new ExempleLoader(exemples);
			parser.parse(activity.getResources()
					.openRawResource(R.raw.exemples), handler1);

			ExempleDAO exempleDAO = new ExempleDAO(activity);
			exempleDAO.open();
			for (Exemple ex : exemples) {
				exempleDAO.ajouter(ex);
				activity.incrementNb();
			}
			exempleDAO.close();

		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (NotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		activity.onBackPressed();
	}

}
