package kimiko.japonais.app.data.tools.convertisseur;

import android.util.Log;

public class Convertisseur {
	private final static String[][] convertionHiragana = new String[][]{
		{"あ", "a"},
		{"い", "i"},
		{"う", "u"},
		{"え", "e"},
		{"お", "o"},
		{"か", "ka"},
		{"き", "ki"},
		{"く", "ku"},
		{"け", "ke"},
		{"こ", "ko"},
		{"さ", "sa"},
		{"し", "shi"},
		{"す", "su"},
		{"せ", "se"},
		{"そ", "so"},
		{"た", "ta"},
		{"ち", "chi"},
		{"つ", "tsu"},
		{"て", "te"},
		{"と", "to"},
		{"な", "na"},
		{"に", "ni"},
		{"ぬ", "nu"},
		{"ね", "ne"},
		{"の", "no"},
		{"は", "ha"},
		{"ひ", "hi"},
		{"ふ", "fu"},
		{"へ", "he"},
		{"ほ", "ho"},
		{"ま", "ma"},
		{"み", "mi"},
		{"む", "mu"},
		{"め", "me"},
		{"も", "mo"},
		{"や", "ya"},
		{"ゆ", "yu"},
		{"よ", "yo"},
		{"ら", "ra"},
		{"り", "ri"},
		{"る", "ru"},
		{"れ", "re"},
		{"ろ", "ro"},
		{"わ", "wa"},
		{"ゐ", "wi"},
		{"ゑ", "we"},
		{"を", "wo"},
		{"ん", "n"},
		{"が", "ga"},
		{"ぎ", "gi"},
		{"ぐ", "gu"},
		{"げ", "ge"},
		{"ご", "go"},
		{"ざ", "za"},
		{"じ", "ji"},
		{"ず", "zu"},
		{"ぜ", "ze"},
		{"ぞ", "zo"},
		{"だ", "da"},
		{"ぢ", "ji"},
		{"づ", "zu"},
		{"で", "de"},
		{"ど", "do"},
		{"ば", "ba"},
		{"び", "bi"},
		{"ぶ", "bu"},
		{"べ", "be"},
		{"ぼ", "bo"},
		{"ぱ", "pa"},
		{"ぴ", "pi"},
		{"ぷ", "pu"},
		{"ぺ", "pe"},
		{"ぽ", "po"},
		{"きゃ", "kya"},
		{"きゅ", "kyu"},
		{"きょ", "kyo"},
		{"ぎゃ", "gya"},
		{"ぎゅ", "gyu"},
		{"ぎょ", "gyo"},
		{"しゃ", "sha"},
		{"しゅ", "shu"},
		{"しょ", "sho"},
		{"じゃ", "ja"},
		{"じゅ", "ju"},
		{"じょ", "jo"},
		{"ちゃ", "cha"},
		{"ちゅ", "chu"},
		{"ちょ", "cho"},
		{"にゃ", "nya"},
		{"にゅ", "nyu"},
		{"にょ", "nyo"},
		{"ひゃ", "hya"},
		{"ひゅ", "hyu"},
		{"ひょ", "hyo"},
		{"びゃ", "bya"},
		{"びゅ", "byu"},
		{"びょ", "byo"},
		{"ぴゃ", "pya"},
		{"ぴゅ", "pyu"},
		{"ぴょ", "pyo"},
		{"みゃ", "mya"},
		{"みゅ", "myu"},
		{"みょ", "myo"},
		{"りゃ", "rya"},
		{"りゅ", "ryu"},
		{"りょ", "ryo"}
	};
	private final static String[][] convertionKatakana = new String[][]{
		{"カ", "ka"},
		{"キ", "ki"},
		{"ク", "ku"},
		{"ケ", "ke"},
		{"コ", "ko"},
		{"サ", "sa"},
		{"シ", "shi"},
		{"ス", "su"},
		{"セ", "se"},
		{"ソ", "so"},
		{"タ", "ta"},
		{"チ", "chi"},
		{"ツ", "tsu"},
		{"テ", "te"},
		{"ト", "to"},
		{"ナ", "na"},
		{"ニ", "ni"},
		{"ヌ", "nu"},
		{"ネ", "ne"},
		{"ノ", "no"},
		{"ハ", "ha"},
		{"ヒ", "hi"},
		{"フ", "fu"},
		{"ヘ", "he"},
		{"ホ", "ho"},
		{"マ", "ma"},
		{"ミ", "mi"},
		{"ム", "mu"},
		{"メ", "me"},
		{"モ", "mo"},
		{"ヤ", "ya"},
		{"ユ", "yu"},
		{"ヨ", "yo"},
		{"ラ", "ra"},
		{"リ", "ri"},
		{"ル", "ru"},
		{"レ", "re"},
		{"ロ", "ro"},
		{"ワ", "wa"},
		{"ヰ", "wi"},
		{"ヱ", "we"},
		{"ヲ", "wo"},
		{"ン", "n"},
		{"ガ", "ga"},
		{"ギ", "gi"},
		{"グ", "gu"},
		{"ゲ", "ge"},
		{"ゴ", "go"},
		{"ザ", "za"},
		{"ジ", "ji"},
		{"ズ", "zu"},
		{"ゼ", "ze"},
		{"ゾ", "zo"},
		{"ダ", "da"},
		{"ヂ", "ji"},
		{"ヅ", "zu"},
		{"デ", "de"},
		{"ド", "do"},
		{"バ", "ba"},
		{"ビ", "bi"},
		{"ブ", "bu"},
		{"ベ", "be"},
		{"ボ", "bo"},
		{"パ", "pa"},
		{"ピ", "pi"},
		{"プ", "pu"},
		{"ペ", "pe"},
		{"ポ", "po"},
		{"キャ", "kya"},
		{"キュ", "kyu"},
		{"キョ", "kyo"},
		{"ギャ", "gya"},
		{"ギュ", "gyu"},
		{"ギョ", "gyo"},
		{"シャ", "sha"},
		{"シュ", "shu"},
		{"ショ", "sho"},
		{"ジャ", "ja"},
		{"ジュ", "ju"},
		{"ジョ", "jo"},
		{"チャ", "cha"},
		{"チュ", "chu"},
		{"チョ", "cho"},
		{"ニャ", "nya"},
		{"ニュ", "nyu"},
		{"ニョ", "nyo"},
		{"ヒャ", "hya"},
		{"ヒュ", "hyu"},
		{"ヒョ", "hyo"},
		{"ビャ", "bya"},
		{"ビュ", "byu"},
		{"ビョ", "byo"},
		{"ピャ", "pya"},
		{"ピュ", "pyu"},
		{"ピョ", "pyo"},
		{"ミャ", "mya"},
		{"ミュ", "myu"},
		{"ミョ", "myo"},
		{"リャ", "rya"},
		{"リュ", "ryu"},
		{"リョ", "ryo"}
	};
	
	public static String convert(String kana) {
		String romaji = new String(kana);
		Log.v(Convertisseur.class.getSimpleName(), "Convertion de : " + kana);
		for(String[] string : convertionHiragana)
			romaji = romaji.replaceAll(string[0], string[1]);
		for(String[] string : convertionKatakana)
			romaji = romaji.replaceAll(string[0], string[1]);
		while(romaji.contains("っ"))
		{
			int index = romaji.indexOf("っ");
			romaji = romaji.substring(0,index)+romaji.charAt(index-1)+romaji.substring(index+1);
		}
		while(romaji.contains("ッ"))
		{
			int index = romaji.indexOf("ッ");
			romaji = romaji.substring(0,index)+romaji.charAt(index-1)+romaji.substring(index+1);
		}
		Log.v(Convertisseur.class.getSimpleName(), "Fin de convertion de : " + romaji);
		return kana;
	}

}
