package kimiko.japonais.app.data.tools.provider;

import kimiko.japonais.app.data.MotDAO;
import android.app.SearchManager;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.net.Uri;
import android.provider.BaseColumns;
import android.util.Log;

public class SuggestionProviderMots extends ContentProvider {
	private String[] mProjection = {BaseColumns._ID, SearchManager.SUGGEST_COLUMN_TEXT_1, SearchManager.SUGGEST_COLUMN_INTENT_ACTION, SearchManager.SUGGEST_COLUMN_INTENT_DATA};
	private MotDAO motDAO;

	@Override
	public String getType(Uri arg0) {
		return null;
	}

	@Override
	public Cursor query(Uri uri, String[] projection, String arg2, String[] arg3, String arg4) {
		MatrixCursor cursor = new MatrixCursor(mProjection);
		Log.v(this.getClass().getSimpleName(), uri.toString());
		if(motDAO == null)
			motDAO = new MotDAO(this.getContext());
		try {
			motDAO.open();
			String query = uri.getLastPathSegment();
			Cursor resulta = motDAO.chercherSimple(query);
			
			while(resulta.moveToNext()) {
				Object[] wordRow = {resulta.getString(0), resulta.getString(1) + " " + resulta.getString(2), Intent.ACTION_VIEW, resulta.getString(1)};
				cursor.addRow(wordRow);
			}
		}
		catch(SQLiteDatabaseLockedException ex)
		{
			ex.printStackTrace();
		}
		motDAO.close();
		return cursor;
	}

	@Override
	public int delete(Uri uri, String selection, String[] selectionArgs) {
		return 0;
	}

	@Override
	public Uri insert(Uri uri, ContentValues values) {
		return null;
	}

	@Override
	public boolean onCreate() {
		return true;
	}

	@Override
	public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
		return 0;
	}
}
