package kimiko.japonais.app.data.ui;

import kimiko.japonais.app.MotActivity;
import kimiko.japonais.app.R;
import kimiko.japonais.app.fragment.MotFragment;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.FrameLayout;

public class DetailListener implements OnClickListener {
	private Context context;
	private Bundle valeur;

	public DetailListener(Context context, Bundle bundle) {
		this.context = context;
		this.valeur = bundle;
	}
	
	@Override
	public void onClick(View v) {
		FrameLayout viewer = (FrameLayout) ((Activity) context).findViewById(R.id.detailContainer);
		if (viewer == null) {
			Intent myIntent = new Intent(context, MotActivity.class);
			myIntent.putExtras(valeur);
			context.startActivity(myIntent);
		} else {
			MotFragment fra = new MotFragment();
			fra.setArguments(valeur);
			
			((FragmentActivity) context).getSupportFragmentManager().beginTransaction().replace(R.id.detailContainer, fra).commit();
		}
	}
}